/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.recipient.common.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpMethod;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.job.recipient.common.http.HTTPRequestExecutor;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.serlialization.SerializationUtils;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public abstract class HTTPRequestExecutorTest<R extends Recipient<?>, E extends HTTPRequestExecutor<R>> {
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final int PORT = 8080;
    public static final String HOST = "localhost";
    public static final String PATH = "/my-service";
    public static final String ENDPOINT = "http://localhost:8080/my-service";
    public static final String JOB_ID = "JOB_ID";
    public static final String JOB_DATA = "JOB_DATA";
    @Mock
    protected Vertx vertx;
    @Mock
    protected WebClient webClient;
    @Mock
    protected HttpRequest<Buffer> request;
    @Mock
    protected MultiMap params;
    @Mock
    protected MultiMap headers;
    @Captor
    protected ArgumentCaptor<Map<String, String>> queryParamsCaptor;
    @Captor
    protected ArgumentCaptor<Map<String, String>> headersCaptor;
    @Captor
    protected ArgumentCaptor<Buffer> bufferCaptor;
    protected ObjectMapper objectMapper;
    protected E tested;

    @BeforeEach
    void setUp() {
        this.objectMapper = SerializationUtils.DEFAULT_OBJECT_MAPPER;
        this.tested = (HTTPRequestExecutor)Mockito.spy(this.createExecutor(5000L, this.vertx, this.objectMapper));
        ((HTTPRequestExecutor)Mockito.doReturn((Object)this.webClient).when(this.tested)).createClient();
        this.tested.initialize();
    }

    protected abstract E createExecutor(long var1, Vertx var3, ObjectMapper var4);

    @Test
    void testExecute() {
        JobDetails job = this.createSimpleJob();
        this.executeAndCollectRequestInfo(this.request, this.params, this.headers, job, false);
        this.assertExecuteConditions();
        this.assertTimeout(5000L);
    }

    @Test
    void testExecuteWithCustomTimeout() {
        JobDetails job = (JobDetails)Mockito.spy((Object)this.createSimpleJob());
        ((JobDetails)Mockito.doReturn((Object)2L).when((Object)job)).getExecutionTimeout();
        ((JobDetails)Mockito.doReturn((Object)ChronoUnit.SECONDS).when((Object)job)).getExecutionTimeoutUnit();
        this.executeAndCollectRequestInfo(this.request, this.params, this.headers, job, false);
        this.assertExecuteConditions();
        this.assertTimeout(2000L);
    }

    protected abstract void assertExecuteConditions();

    @Test
    void testExecuteWithError() {
        JobDetails job = this.createSimpleJob();
        this.executeAndCollectRequestInfo(this.request, this.params, this.headers, job, true);
        this.assertExecuteWithErrorConditions();
    }

    protected abstract void assertExecuteWithErrorConditions();

    @Test
    void testExecutePeriodic() {
        JobDetails job = this.createPeriodicJob();
        this.executeAndCollectRequestInfo(this.request, this.params, this.headers, job, false);
        this.assertExecutePeriodicConditions();
    }

    protected abstract void assertExecutePeriodicConditions();

    protected abstract JobDetails createSimpleJob();

    protected abstract JobDetails createPeriodicJob();

    private Map<String, String>[] executeAndCollectRequestInfo(HttpRequest<Buffer> request, MultiMap params, MultiMap headers, JobDetails scheduledJob, boolean mockError) {
        ((WebClient)Mockito.doReturn(request).when((Object)this.webClient)).request(HttpMethod.POST, 8080, HOST, PATH);
        ((HttpRequest)Mockito.doReturn(request).when(request)).timeout(ArgumentMatchers.anyLong());
        ((HttpRequest)Mockito.doReturn((Object)params).when(request)).queryParams();
        ((HttpRequest)Mockito.doReturn((Object)headers).when(request)).headers();
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        int statusCode = mockError ? 500 : 200;
        ((HttpResponse)Mockito.doReturn((Object)statusCode).when((Object)httpResponse)).statusCode();
        ((HttpRequest)Mockito.doReturn((Object)Uni.createFrom().item((Object)httpResponse)).when(request)).sendBuffer((Buffer)ArgumentMatchers.any());
        JobExecutionResponse response = (JobExecutionResponse)this.tested.execute(scheduledJob).onFailure().recoverWithNull().await().indefinitely();
        ((WebClient)Mockito.verify((Object)this.webClient)).request(HttpMethod.POST, 8080, HOST, PATH);
        ((HttpRequest)Mockito.verify(request)).sendBuffer((Buffer)this.bufferCaptor.capture());
        ((HttpRequest)Mockito.verify(request)).queryParams();
        ((HttpRequest)Mockito.verify(request)).headers();
        ((MultiMap)Mockito.verify((Object)params)).addAll((Map)this.queryParamsCaptor.capture());
        ((MultiMap)Mockito.verify((Object)headers)).addAll((Map)this.headersCaptor.capture());
        ((HttpRequest)Mockito.verify(request)).sendBuffer((Buffer)ArgumentMatchers.any());
        if (!mockError) {
            Assertions.assertThat((String)response.getJobId()).isEqualTo(JOB_ID);
            Assertions.assertThat((String)response.getCode()).isEqualTo("200");
        } else {
            Assertions.assertThat((Object)response).isNull();
        }
        return new Map[]{(Map)this.headersCaptor.getValue(), (Map)this.queryParamsCaptor.getValue()};
    }

    private void assertTimeout(long expectedTimeout) {
        ((HttpRequest)Mockito.verify(this.request)).timeout(expectedTimeout);
    }
}

