/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.recipient.common.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.job.recipient.common.http.HTTPRequest;
import org.kie.kogito.job.recipient.common.http.converters.HttpConverters;
import org.kie.kogito.jobs.api.URIBuilder;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.exception.JobExecutionException;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPRequestExecutor<R extends Recipient<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPRequestExecutor.class);
    protected long timeout;
    protected Vertx vertx;
    protected WebClient client;
    protected ObjectMapper objectMapper;

    protected HTTPRequestExecutor() {
    }

    protected HTTPRequestExecutor(long timeout, Vertx vertx, ObjectMapper objectMapper) {
        this.timeout = timeout;
        this.vertx = vertx;
        this.objectMapper = objectMapper;
    }

    protected void initialize() {
        this.client = this.createClient();
    }

    public WebClient createClient() {
        return WebClient.create((Vertx)this.vertx);
    }

    public Uni<JobExecutionResponse> execute(JobDetails jobDetails) {
        return Uni.createFrom().item((Object)jobDetails).chain(job -> {
            R recipient = this.getRecipient((JobDetails)job);
            String limit = this.getLimit((JobDetails)job);
            HTTPRequest request = this.buildRequest(recipient, limit);
            long requestTimeout = this.getTimeoutInMillis((JobDetails)job);
            return this.executeRequest(request, requestTimeout).onFailure().transform(unexpected -> new JobExecutionException(job.getId(), "Unexpected error when executing HTTP request for job: " + jobDetails.getId() + ". " + unexpected.getMessage())).onItem().transform(response -> JobExecutionResponse.builder().message(response.bodyAsString()).code(String.valueOf(response.statusCode())).now().jobId(job.getId()).build()).chain(this::handleResponse);
        });
    }

    protected abstract R getRecipient(JobDetails var1);

    protected abstract HTTPRequest buildRequest(R var1, String var2);

    protected Uni<HttpResponse<Buffer>> executeRequest(HTTPRequest request, long timeout) {
        LOGGER.debug("Executing request {}", (Object)request);
        URI uri = URIBuilder.toURI((String)request.getUrl());
        HttpRequest clientRequest = this.client.request(HttpConverters.convertHttpMethod(request.getMethod()), uri.getPort(), uri.getHost(), uri.getPath()).timeout(timeout);
        clientRequest.queryParams().addAll(HTTPRequestExecutor.filterEntries(request.getQueryParams()));
        clientRequest.headers().addAll(HTTPRequestExecutor.filterEntries(request.getHeaders()));
        if (request.getBody() != null) {
            return clientRequest.sendBuffer(this.buildBuffer(request.getBody()));
        }
        return clientRequest.send();
    }

    protected Buffer buildBuffer(Object body) {
        if (body instanceof String) {
            return Buffer.buffer((String)((String)body));
        }
        if (body instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])body));
        }
        if (body instanceof JsonNode) {
            try {
                return Buffer.buffer((byte[])this.objectMapper.writeValueAsBytes(body));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to encode body as JSON: " + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Unexpected body type: " + body.getClass());
    }

    protected <T extends JobExecutionResponse> Uni<T> handleResponse(T response) {
        LOGGER.debug("Handle response {}", response);
        return Uni.createFrom().item(response).onItem().transform(JobExecutionResponse::getCode).onItem().transform(Integer::valueOf).chain(code -> Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)code)) ? this.handleSuccess(response) : this.handleError(response));
    }

    protected <T extends JobExecutionResponse> Uni<T> handleError(T response) {
        return Uni.createFrom().item(response).onItem().invoke(r -> LOGGER.debug("Error executing job {}.", r)).onItem().failWith(() -> new JobExecutionException(response.getJobId(), "Response error when executing HTTP request for " + response));
    }

    protected <T extends JobExecutionResponse> Uni<T> handleSuccess(T response) {
        return Uni.createFrom().item(response).onItem().invoke(r -> LOGGER.debug("Success executing job {}.", r));
    }

    protected String getLimit(JobDetails job) {
        if (job.getTrigger() instanceof SimpleTimerTrigger) {
            return String.valueOf(this.getRepeatableJobCountDown((SimpleTimerTrigger)job.getTrigger()));
        }
        if (job.getTrigger() instanceof IntervalTrigger) {
            return String.valueOf(this.getRepeatableJobCountDown((IntervalTrigger)job.getTrigger()));
        }
        return "0";
    }

    protected long getTimeoutInMillis(JobDetails job) {
        if (job.getExecutionTimeout() == null) {
            return this.timeout;
        }
        ChronoUnit timeoutUnit = job.getExecutionTimeoutUnit() != null ? job.getExecutionTimeoutUnit() : ChronoUnit.MILLIS;
        return timeoutUnit == ChronoUnit.MILLIS ? job.getExecutionTimeout().longValue() : timeoutUnit.getDuration().multipliedBy(job.getExecutionTimeout()).toMillis();
    }

    protected int getRepeatableJobCountDown(IntervalTrigger trigger) {
        return trigger.getRepeatLimit() - trigger.getRepeatCount() - 1;
    }

    protected int getRepeatableJobCountDown(SimpleTimerTrigger trigger) {
        return trigger.getRepeatCount() - trigger.getCurrentRepeatCount();
    }

    protected static <K, V> Map<K, V> filterEntries(Map<K, V> source) {
        if (source == null) {
            return Collections.emptyMap();
        }
        return source.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

