/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.sink.recipient.deployment;

import io.cloudevents.SpecVersion;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.job.sink.recipient.SinkJobExecutor;
import org.kie.kogito.job.sink.recipient.SinkRecipientValidator;
import org.kie.kogito.job.sink.recipient.deployment.JobSinkRecipientProcessor;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipient;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientPayloadData;
import org.kie.kogito.jobs.service.api.schedule.cron.CronSchedule;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

class JobSinkRecipientProcessorTest {
    private final JobSinkRecipientProcessor processor = new JobSinkRecipientProcessor();

    JobSinkRecipientProcessorTest() {
    }

    @Test
    void feature() {
        Assertions.assertThat((String)this.processor.feature().getName()).isEqualTo("job-sink-recipient");
    }

    @Test
    void additionalBeans() {
        AdditionalBeanBuildItem additionalBeans = this.processor.additionalBeans();
        Assertions.assertThat((List)additionalBeans.getBeanClasses()).containsExactlyInAnyOrder((Object[])new String[]{SinkJobExecutor.class.getName(), SinkRecipientValidator.class.getName()});
    }

    @Test
    void contributeClassesToIndex() {
        BuildProducer producer = (BuildProducer)Mockito.mock(BuildProducer.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AdditionalIndexedClassesBuildItem.class);
        this.processor.contributeClassesToIndex(producer);
        ((BuildProducer)Mockito.verify((Object)producer)).produce((BuildItem)((AdditionalIndexedClassesBuildItem)captor.capture()));
        AdditionalIndexedClassesBuildItem buildItem = (AdditionalIndexedClassesBuildItem)captor.getValue();
        Assertions.assertThat((Object)buildItem).isNotNull();
        Assertions.assertThat((Collection)buildItem.getClassesToIndex()).containsExactlyInAnyOrder((Object[])new String[]{SinkRecipient.class.getName(), SinkRecipientPayloadData.class.getName(), SinkRecipientBinaryPayloadData.class.getName(), SinkRecipientJsonPayloadData.class.getName(), SinkRecipient.ContentMode.class.getName(), CronSchedule.class.getName(), TimerSchedule.class.getName(), TemporalUnit.class.getName(), SpecVersion.class.getName()});
    }
}

