/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.sink.recipient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.cloudevents.SpecVersion;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.kie.kogito.job.recipient.common.http.HTTPRequestExecutorTest;
import org.kie.kogito.job.sink.recipient.SinkJobExecutor;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipient;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipientPayloadData;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;

class SinkJobExecutorTest
extends HTTPRequestExecutorTest<SinkRecipient<?>, SinkJobExecutor> {
    public static final String JOB_CE_TYPE = "JOB_CE_TYPE";
    public static final SpecVersion JOB_CE_SPECVERSION = SpecVersion.V1;
    public static final URI JOB_CE_SOURCE = URI.create("http://JOB_CE_SOURCE");
    public static final String JOB_CE_SUBJECT = "JOB_CE_SUBJECT";
    public static final String JOB_CE_DATACONTENTTYPE = "JOB_CE_DATACONTENTTYPE";
    public static final URI JOB_CE_DATASCHEMA = URI.create("http://JOB_CE_DATASCHEMA");
    public static final String PROPERTY_NAME = "PROPERTY_NAME";
    public static final String PROPERTY_VALUE = "PROPERTY_VALUE";

    SinkJobExecutorTest() {
    }

    protected SinkJobExecutor createExecutor(long timeout, Vertx vertx, ObjectMapper objectMapper) {
        return new SinkJobExecutor(timeout, vertx, objectMapper);
    }

    protected void assertExecuteConditions() {
        Assertions.assertThat((Map)((Map)this.queryParamsCaptor.getValue())).isEmpty();
        Assertions.assertThat((Map)((Map)this.headersCaptor.getValue())).hasSize(9);
        this.assertCommonHeaders((Map)this.headersCaptor.getValue());
        Assertions.assertThat((Map)((Map)this.headersCaptor.getValue())).containsEntry((Object)"ce-limit", (Object)"0");
        this.assertCommonBuffer();
    }

    protected void assertExecuteWithErrorConditions() {
        this.assertExecuteConditions();
    }

    protected void assertExecutePeriodicConditions() {
        Assertions.assertThat((Map)((Map)this.queryParamsCaptor.getValue())).isEmpty();
        Assertions.assertThat((Map)((Map)this.headersCaptor.getValue())).hasSize(9);
        this.assertCommonHeaders((Map)this.headersCaptor.getValue());
        Assertions.assertThat((Map)((Map)this.headersCaptor.getValue())).containsEntry((Object)"ce-limit", (Object)"10");
        this.assertCommonBuffer();
    }

    private void assertCommonHeaders(Map<String, String> headers) {
        Assertions.assertThat((String)headers.get("ce-id")).isNotNull();
        Assertions.assertThat((String)headers.get("ce-time")).isNotNull();
        Assertions.assertThat(headers).containsEntry((Object)"ce-source", (Object)JOB_CE_SOURCE.toString());
        Assertions.assertThat(headers).containsEntry((Object)"ce-subject", (Object)JOB_CE_SUBJECT);
        Assertions.assertThat(headers).containsEntry((Object)"ce-specversion", (Object)JOB_CE_SPECVERSION.toString());
        Assertions.assertThat(headers).containsEntry((Object)"ce-type", (Object)JOB_CE_TYPE);
        Assertions.assertThat(headers).containsEntry((Object)"content-type", (Object)JOB_CE_DATACONTENTTYPE);
        Assertions.assertThat(headers).containsEntry((Object)"ce-dataschema", (Object)JOB_CE_DATASCHEMA.toString());
    }

    private void assertCommonBuffer() {
        ((ObjectAssert)Assertions.assertThat((Object)((Buffer)this.bufferCaptor.getValue())).isNotNull()).hasToString("{\"PROPERTY_NAME\":\"PROPERTY_VALUE\"}");
    }

    protected JobDetails createSimpleJob() {
        SinkRecipient<?> recipient = this.createRecipient();
        return JobDetails.builder().recipient((Recipient)new RecipientInstance(recipient)).id("JOB_ID").build();
    }

    protected JobDetails createPeriodicJob() {
        SinkRecipient<?> recipient = this.createRecipient();
        return JobDetails.builder().id("JOB_ID").recipient((Recipient)new RecipientInstance(recipient)).trigger((Trigger)new SimpleTimerTrigger(DateUtil.toDate((OffsetDateTime)OffsetDateTime.now()), 1L, ChronoUnit.MILLIS, 10, null)).build();
    }

    private SinkRecipient<?> createRecipient() {
        ObjectNode json = this.objectMapper.createObjectNode().put(PROPERTY_NAME, PROPERTY_VALUE);
        return SinkRecipient.builder().forJsonPayload().payload((SinkRecipientPayloadData)SinkRecipientJsonPayloadData.from((JsonNode)json)).sinkUrl("http://localhost:8080/my-service").contentMode(SinkRecipient.ContentMode.BINARY).ceSpecVersion(JOB_CE_SPECVERSION).ceEventType(JOB_CE_TYPE).ceSource(JOB_CE_SOURCE).ceDataContentType(JOB_CE_DATACONTENTTYPE).ceDataSchema(JOB_CE_DATASCHEMA).ceSubject(JOB_CE_SUBJECT).build();
    }
}

