/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.sink.recipient;

import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.job.sink.recipient.SinkRecipientValidator;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.recipient.sink.SinkRecipient;
import org.kie.kogito.jobs.service.validation.ValidatorContext;

class SinkRecipientValidatorTest {
    private static final long MAX_TIMEOUT = 3000L;
    public static final String SINK_URL = "http://my_sink-url";
    public static final String CE_TYPE = "MY_CE_TYPE";
    public static final URI CE_SOURCE = URI.create("http://my_ce_source");
    public static final String MY_EXTENSION = "myextension";
    private SinkRecipientValidator validator;
    private SinkRecipient<?> recipient;

    SinkRecipientValidatorTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.validator = new SinkRecipientValidator(3000L);
        this.recipient = new SinkRecipient();
        this.recipient.setSinkUrl(SINK_URL);
        this.recipient.setCeType(CE_TYPE);
        this.recipient.setCeSource(CE_SOURCE);
        this.recipient.addCeExtension(MY_EXTENSION, (Object)"some value");
    }

    @Test
    void acceptNonNull() {
        Assertions.assertThat((boolean)this.validator.accept(this.recipient)).isTrue();
    }

    @Test
    void acceptNull() {
        Assertions.assertThat((boolean)this.validator.accept(null)).isFalse();
    }

    @Test
    void validateSuccessful() {
        Assertions.assertThatNoException().isThrownBy(() -> this.validator.validate(this.recipient, new ValidatorContext()));
    }

    @Test
    void validateNull() {
        this.recipient = null;
        this.testUnsuccessfulValidation("Recipient must be a non-null instance of");
    }

    @Test
    void validateNullSinkURL() {
        this.recipient.setSinkUrl(null);
        this.testUnsuccessfulValidation("SinkRecipient sinkUrl must have a non empty value.");
    }

    @Test
    void validateMalformedSinkURL() {
        this.recipient.setSinkUrl("bad url");
        this.testUnsuccessfulValidation("SinkRecipient must have a valid url.");
    }

    @Test
    void validateNullContentModeL() {
        this.recipient.setContentMode(null);
        this.testUnsuccessfulValidation("SinkRecipient contentMode must have a non null value.");
    }

    @Test
    void validateNullCeSpecVersion() {
        this.recipient.setCeSpecVersion(null);
        this.testUnsuccessfulValidation("SinkRecipient ce-specversion must have a non null value.");
    }

    @Test
    void validateNullOrEmptyCeType() {
        String error = "SinkRecipient ce-type must have a non empty value.";
        this.recipient.setCeType(null);
        this.testUnsuccessfulValidation(error);
        this.recipient.setCeType("");
        this.testUnsuccessfulValidation(error);
        this.recipient.setCeType("   ");
        this.testUnsuccessfulValidation(error);
    }

    @Test
    void validateNullCeSource() {
        this.recipient.setCeSource(null);
        this.testUnsuccessfulValidation("SinkRecipient ce-source must have a non null value.");
    }

    @Test
    void validateWrongExtensionName() {
        this.recipient.getCeExtensions().put("bad_name", "my_value");
        this.testUnsuccessfulValidation("Invalid attribute or extension name: 'bad_name'");
    }

    @Test
    void validateJobExecutionTimeoutOK() {
        Job job = Job.builder().executionTimeout(Long.valueOf(3L)).executionTimeoutUnit(TemporalUnit.SECONDS).build();
        this.validator.validate(this.recipient, new ValidatorContext(job));
    }

    @Test
    void validateJobExecutionTimeoutExceedsMaxTimeoutMillis() {
        Job job = Job.builder().executionTimeout(Long.valueOf(3001L)).build();
        this.testUnsuccessfulValidation("Job executionTimeout configuration can not exceed the SinkRecipient max-timeout-in-millis", new ValidatorContext(job));
    }

    @Test
    void validateJobExecutionTimeoutExceedsMaxTimeoutSeconds() {
        Job job = Job.builder().executionTimeout(Long.valueOf(3000L)).executionTimeoutUnit(TemporalUnit.SECONDS).build();
        this.testUnsuccessfulValidation("Job executionTimeout configuration can not exceed the SinkRecipient max-timeout-in-millis", new ValidatorContext(job));
    }

    private void testUnsuccessfulValidation(String expectedError) {
        this.testUnsuccessfulValidation(expectedError, new ValidatorContext());
    }

    private void testUnsuccessfulValidation(String expectedError, ValidatorContext context) {
        Assertions.assertThatThrownBy(() -> this.validator.validate(this.recipient, context)).hasMessageStartingWith(expectedError);
    }
}

