/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management;

import java.net.URI;
import java.util.Objects;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.api.URIBuilder;

public abstract class RestJobsService
implements JobsService {
    public static final String JOBS_PATH = "/jobs";
    private URI jobsServiceUri;
    private String callbackEndpoint;

    public RestJobsService(String jobServiceUrl, String callbackEndpoint) {
        this.jobsServiceUri = Objects.nonNull(jobServiceUrl) ? this.buildJobsServiceURI(jobServiceUrl) : null;
        this.callbackEndpoint = callbackEndpoint;
    }

    public String getCallbackEndpoint(ProcessInstanceJobDescription description) {
        return URIBuilder.toURI((String)(this.callbackEndpoint + "/management/jobs/" + description.processId() + "/instances/" + description.processInstanceId() + "/timers/" + description.id())).toString();
    }

    private URI buildJobsServiceURI(String jobServiceUrl) {
        return URIBuilder.toURI((String)(jobServiceUrl + JOBS_PATH));
    }

    public URI getJobsServiceUri() {
        return this.jobsServiceUri;
    }
}

