/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management;

import java.net.URI;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.management.RestJobsService;

public class RestJobsServiceTest {
    public static final String CALLBACK_URL = "http://localhost";
    public static final String JOB_SERVICE_URL = "http://localhost:8085";
    private final RestJobsService tested = new RestJobsService("http://localhost:8085", "http://localhost"){

        public String scheduleProcessJob(ProcessJobDescription description) {
            return null;
        }

        public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
            return null;
        }

        public boolean cancelJob(String id) {
            return false;
        }

        public ZonedDateTime getScheduledTime(String id) {
            return null;
        }
    };

    @Test
    void testGetCallbackEndpoint() {
        ProcessInstanceJobDescription description = ProcessInstanceJobDescription.of((long)123L, (ExpirationTime)ExactExpirationTime.now(), (String)"processInstanceId", (String)"processId");
        String callbackEndpoint = this.tested.getCallbackEndpoint(description);
        Assertions.assertThat((String)callbackEndpoint).isEqualTo("http://localhost:80/management/jobs/processId/instances/processInstanceId/timers/" + description.id());
    }

    @Test
    void testGetJobsServiceUri() {
        URI jobsServiceUri = this.tested.getJobsServiceUri();
        Assertions.assertThat((String)jobsServiceUri.toString()).isEqualTo("http://localhost:8085/jobs");
    }
}

