/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

class CompletedStage<T>
implements CompletionStage<T> {
    static final CompletedStage<Void> VOID = CompletedStage.of(null);
    private final T result;
    private final Throwable exception;

    private CompletedStage(T result2, Throwable exception) {
        this.result = result2;
        this.exception = exception;
    }

    private <U> CompletedStage<U> typedException() {
        assert (this.exception != null);
        return this;
    }

    static <T> CompletedStage<T> of(T t) {
        return new CompletedStage<T>(t, null);
    }

    static <T> CompletedStage<T> exception(Throwable e) {
        return new CompletedStage<Object>(null, Objects.requireNonNull(e));
    }

    private static <T> CompletedStage<T> completionException(Throwable e) {
        return CompletedStage.exception(CompletedStage.wrapIfNecessary(e));
    }

    private static <T> CompletionException wrapIfNecessary(Throwable e) {
        return e instanceof CompletionException ? (CompletionException)e : new CompletionException(e);
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
        Objects.requireNonNull(fn);
        if (this.exception == null) {
            U u;
            try {
                u = fn.apply(this.result);
            }
            catch (Throwable e) {
                return CompletedStage.completionException(e);
            }
            return CompletedStage.of(u);
        }
        return this.typedException();
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        Objects.requireNonNull(fn);
        if (this.exception == null) {
            return CompletableFuture.supplyAsync(() -> fn.apply((T)this.result));
        }
        return this.typedException();
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn);
        if (this.exception == null) {
            return CompletableFuture.supplyAsync(() -> fn.apply((T)this.result), executor);
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.exception == null) {
            try {
                action.accept(this.result);
            }
            catch (Throwable e) {
                return CompletedStage.completionException(e);
            }
            return VOID;
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.exception == null) {
            return CompletableFuture.runAsync(() -> action.accept((T)this.result));
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        Objects.requireNonNull(action);
        if (this.exception == null) {
            return CompletableFuture.runAsync(() -> action.accept((T)this.result), executor);
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        Objects.requireNonNull(action);
        if (this.exception == null) {
            try {
                action.run();
            }
            catch (Throwable e) {
                return CompletedStage.completionException(e);
            }
            return VOID;
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        if (this.exception == null) {
            return CompletableFuture.runAsync(action);
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        if (this.exception == null) {
            return CompletableFuture.runAsync(action, executor);
        }
        return this.typedException();
    }

    @Override
    public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        Objects.requireNonNull(fn);
        return other.thenApply(this.exception == null ? u -> fn.apply((T)this.result, (Object)u) : u -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        });
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        Objects.requireNonNull(fn);
        return other.thenApplyAsync(this.exception == null ? u -> fn.apply((T)this.result, (Object)u) : u -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        });
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        Objects.requireNonNull(fn);
        return other.thenApplyAsync(this.exception == null ? u -> fn.apply((T)this.result, (Object)u) : u -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        }, executor);
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        Objects.requireNonNull(action);
        return other.thenAccept(this.exception == null ? u -> action.accept((T)this.result, (Object)u) : u -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        });
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        Objects.requireNonNull(action);
        return other.thenAcceptAsync(this.exception == null ? u -> action.accept((T)this.result, (Object)u) : u -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        });
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        Objects.requireNonNull(action);
        return other.thenAcceptAsync(this.exception == null ? u -> action.accept((T)this.result, (Object)u) : u -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        }, executor);
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        Objects.requireNonNull(action);
        return other.thenRun(this.exception == null ? action : () -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        });
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        Objects.requireNonNull(action);
        return other.thenRunAsync(this.exception == null ? action : () -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        });
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        Objects.requireNonNull(action);
        return other.thenRunAsync(this.exception == null ? action : () -> {
            throw CompletedStage.wrapIfNecessary(this.exception);
        }, executor);
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.thenApply(fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.thenApplyAsync(fn, executor);
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.thenAccept(action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.thenAcceptAsync(action);
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.thenAcceptAsync(action, executor);
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.thenRun(action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.thenRunAsync(action);
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.thenRunAsync(action, executor);
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        Objects.requireNonNull(fn);
        if (this.exception == null) {
            try {
                return fn.apply(this.result);
            }
            catch (Throwable e) {
                return CompletedStage.completionException(e);
            }
        }
        return this.typedException();
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsyncInternal(fn, CompletableFuture::runAsync);
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.thenComposeAsyncInternal(fn, Objects.requireNonNull(executor));
    }

    private <U> CompletionStage<U> thenComposeAsyncInternal(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        Objects.requireNonNull(fn);
        if (this.exception == null) {
            CompletableFuture ret = new CompletableFuture();
            executor.execute(() -> {
                try {
                    ((CompletionStage)fn.apply((T)this.result)).whenComplete((u, exc) -> {
                        if (exc == null) {
                            ret.complete(u);
                        } else {
                            ret.completeExceptionally((Throwable)exc);
                        }
                    });
                }
                catch (Throwable e) {
                    ret.completeExceptionally(CompletedStage.wrapIfNecessary(e));
                }
            });
            return ret;
        }
        return this.typedException();
    }

    @Override
    public CompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        T t;
        Objects.requireNonNull(fn);
        if (this.exception == null) {
            return this;
        }
        try {
            t = fn.apply(this.exception);
        }
        catch (Throwable e) {
            return CompletedStage.completionException(e);
        }
        return CompletedStage.of(t);
    }

    @Override
    public CompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        block2: {
            Objects.requireNonNull(action);
            try {
                action.accept(this.result, this.exception);
            }
            catch (Throwable e) {
                if (this.exception != null) break block2;
                return CompletedStage.completionException(e);
            }
        }
        return this;
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.whenCompleteAsyncInternal(action, CompletableFuture::runAsync);
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.whenCompleteAsyncInternal(action, Objects.requireNonNull(executor));
    }

    private CompletionStage<T> whenCompleteAsyncInternal(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        Objects.requireNonNull(action);
        CompletableFuture ret = new CompletableFuture();
        executor.execute(() -> {
            try {
                action.accept((T)this.result, this.exception);
            }
            catch (Throwable e) {
                ret.completeExceptionally(this.exception == null ? e : this.exception);
                return;
            }
            if (this.exception == null) {
                ret.complete(this.result);
            } else {
                ret.completeExceptionally(this.exception);
            }
        });
        return ret;
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        U u;
        Objects.requireNonNull(fn);
        try {
            u = fn.apply(this.result, this.exception);
        }
        catch (Throwable e) {
            return CompletedStage.completionException(e);
        }
        return CompletedStage.of(u);
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        Objects.requireNonNull(fn);
        return CompletableFuture.supplyAsync(() -> fn.apply((T)this.result, this.exception));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn);
        return CompletableFuture.supplyAsync(() -> fn.apply((T)this.result, this.exception), executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        if (this.exception == null) {
            return CompletableFuture.completedFuture(this.result);
        }
        CompletableFuture ret = new CompletableFuture();
        ret.completeExceptionally(this.exception);
        return ret;
    }
}

