/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.spi.LoginModule;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;
import org.apache.kafka.common.security.scram.ScramExtensionsCallback;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Utils;

@TargetClass(value=SaslClientCallbackHandler.class)
final class Target_org_apache_kafka_common_security_authenticator_SaslClientCallbackHandler
implements AuthenticateCallbackHandler {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.None)
    String mechanism;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.None)
    Subject subject;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.None)
    Map<String, ?> sharedState;

    Target_org_apache_kafka_common_security_authenticator_SaslClientCallbackHandler() {
    }

    @Override
    @Substitute
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.mechanism = saslMechanism;
        for (AppConfigurationEntry entry : jaasConfigEntries) {
            try {
                if (this.subject == null) {
                    this.subject = new Subject();
                }
                if (this.sharedState == null) {
                    this.sharedState = new HashMap();
                }
                LoginModule result2 = Utils.newInstance(entry.getLoginModuleName(), LoginModule.class);
                result2.initialize(this.subject, this, this.sharedState, entry.getOptions());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Substitute
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            Object extensions;
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                if (this.subject != null && !this.subject.getPublicCredentials(String.class).isEmpty()) {
                    nc.setName(this.subject.getPublicCredentials(String.class).iterator().next());
                    continue;
                }
                nc.setName(nc.getDefaultName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.subject != null && !this.subject.getPrivateCredentials(String.class).isEmpty()) {
                    char[] password = this.subject.getPrivateCredentials(String.class).iterator().next().toCharArray();
                    ((PasswordCallback)callback).setPassword(password);
                    continue;
                }
                String errorMessage = "Could not login: the client is being asked for a password, but the Kafka client code does not currently support obtaining a password from the user.";
                throw new UnsupportedCallbackException(callback, errorMessage);
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                rc.setText(rc.getDefaultText());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                AuthorizeCallback ac = (AuthorizeCallback)callback;
                String authId = ac.getAuthenticationID();
                String authzId = ac.getAuthorizationID();
                ac.setAuthorized(authId.equals(authzId));
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzId);
                continue;
            }
            if (callback instanceof ScramExtensionsCallback) {
                if (!ScramMechanism.isScram(this.mechanism) || this.subject == null || this.subject.getPublicCredentials(Map.class).isEmpty()) continue;
                extensions = this.subject.getPublicCredentials(Map.class).iterator().next();
                ((ScramExtensionsCallback)callback).extensions((Map<String, String>)extensions);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                if ("GSSAPI".equals(this.mechanism) || this.subject == null || this.subject.getPublicCredentials(SaslExtensions.class).isEmpty()) continue;
                extensions = this.subject.getPublicCredentials(SaslExtensions.class).iterator().next();
                ((SaslExtensionsCallback)callback).extensions((SaslExtensions)extensions);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
        }
    }

    @Override
    @Substitute
    @KeepOriginal
    public void close() {
    }
}

