/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.OidcTokenCredential;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jose4j.lang.UnresolvableKeyException;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    static final String REFRESH_TOKEN_GRANT_RESPONSE = "refresh_token_grant_response";
    static final String NEW_AUTHENTICATION = "new_authentication";
    private static final Uni<TokenVerificationResult> NULL_CODE_ACCESS_TOKEN_UNI = Uni.createFrom().nullItem();
    private static final Uni<UserInfo> NULL_USER_INFO_UNI = Uni.createFrom().nullItem();
    private static final String CODE_ACCESS_TOKEN_RESULT = "code_flow_access_token_result";
    @Inject
    DefaultTenantConfigResolver tenantResolver;
    private BlockingTaskRunner<Void> uniVoidOidcContext = new BlockingTaskRunner();
    private BlockingTaskRunner<TokenIntrospection> getIntrospectionRequestContext = new BlockingTaskRunner();
    private BlockingTaskRunner<UserInfo> getUserInfoRequestContext = new BlockingTaskRunner();

    @Override
    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    @Override
    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        OidcTokenCredential credential = (OidcTokenCredential)request.getToken();
        final RoutingContext vertxContext = credential.getRoutingContext();
        vertxContext.put(AuthenticationRequestContext.class.getName(), context);
        Uni<TenantConfigContext> tenantConfigContext = this.tenantResolver.resolveContext(vertxContext);
        return tenantConfigContext.onItem().transformToUni(new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final TenantConfigContext tenantConfigContext) {
                return Uni.createFrom().deferred(new Supplier<Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> get() {
                        return OidcIdentityProvider.this.authenticate(request, vertxContext, tenantConfigContext);
                    }
                });
            }
        });
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, RoutingContext vertxContext, TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.publicKey.isPresent()) {
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return this.validateAllTokensWithOidcServer(vertxContext, request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateAllTokensWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        Uni<TokenVerificationResult> codeAccessTokenUni = this.verifyCodeFlowAccessTokenUni(vertxContext, request, resolvedContext);
        return codeAccessTokenUni.onItemOrFailure().transformToUni(new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult codeAccessToken, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure(new AuthenticationFailedException(t));
                }
                return OidcIdentityProvider.this.validateTokenWithOidcServer(vertxContext, request, resolvedContext, codeAccessToken);
            }
        });
    }

    private Uni<SecurityIdentity> validateTokenWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, TokenVerificationResult codeAccessTokenResult) {
        if (codeAccessTokenResult != null) {
            vertxContext.put(CODE_ACCESS_TOKEN_RESULT, codeAccessTokenResult);
        }
        Uni<UserInfo> userInfo = resolvedContext.oidcConfig.authentication.isUserInfoRequired() ? this.getUserInfoUni(vertxContext, request, resolvedContext) : NULL_USER_INFO_UNI;
        return userInfo.onItemOrFailure().transformToUni(new BiFunction<UserInfo, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(UserInfo userInfo, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure(new AuthenticationFailedException(t));
                }
                return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(vertxContext, request, resolvedContext, userInfo);
            }
        });
    }

    private Uni<SecurityIdentity> createSecurityIdentityWithOidcServer(final RoutingContext vertxContext, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, final UserInfo userInfo) {
        Uni<TokenVerificationResult> tokenUni = this.verifyTokenUni(resolvedContext, request.getToken().getToken());
        return tokenUni.onItemOrFailure().transformToUni(new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult result2, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure(new AuthenticationFailedException(t));
                }
                TokenCredential tokenCred = request.getToken();
                JsonObject tokenJson = result2.localVerificationResult;
                if (tokenJson == null) {
                    tokenJson = OidcUtils.decodeJwtContent(tokenCred.getToken());
                }
                if (tokenJson != null) {
                    try {
                        OidcUtils.validatePrimaryJwtTokenType(resolvedContext.oidcConfig.token, tokenJson);
                        JsonObject rolesJson = OidcIdentityProvider.getRolesJson(vertxContext, resolvedContext, tokenCred, tokenJson, userInfo);
                        QuarkusSecurityIdentity securityIdentity = OidcUtils.validateAndCreateIdentity(vertxContext, tokenCred, resolvedContext, tokenJson, rolesJson, userInfo);
                        if (OidcIdentityProvider.tokenAutoRefreshPrepared(tokenJson, vertxContext, resolvedContext.oidcConfig)) {
                            return Uni.createFrom().failure(new TokenAutoRefreshException(securityIdentity));
                        }
                        return Uni.createFrom().item(securityIdentity);
                    }
                    catch (Throwable ex) {
                        return Uni.createFrom().failure(new AuthenticationFailedException(ex));
                    }
                }
                if (tokenCred instanceof IdTokenCredential || tokenCred instanceof AccessTokenCredential && !((AccessTokenCredential)tokenCred).isOpaque()) {
                    return Uni.createFrom().failure(new AuthenticationFailedException("JWT token can not be converted to JSON"));
                }
                QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                builder.addCredential(tokenCred);
                OidcUtils.setSecurityIdentityUserInfo(builder, userInfo);
                OidcUtils.setSecurityIdentityIntrospecton(builder, result2.introspectionResult);
                OidcUtils.setSecurityIdentityConfigMetadata(builder, resolvedContext);
                String principalMember = "";
                if (result2.introspectionResult.contains("username")) {
                    principalMember = "username";
                } else if (result2.introspectionResult.contains("sub")) {
                    principalMember = "sub";
                }
                final String userName = principalMember.isEmpty() ? "" : result2.introspectionResult.getString(principalMember);
                builder.setPrincipal(new Principal(){

                    @Override
                    public String getName() {
                        return userName;
                    }
                });
                if (result2.introspectionResult.contains("scope")) {
                    for (String role : result2.introspectionResult.getString("scope").split(" ")) {
                        builder.addRole(role.trim());
                    }
                }
                if (userInfo != null) {
                    OidcUtils.setSecurityIdentityRoles(builder, resolvedContext.oidcConfig, new JsonObject(userInfo.getJsonObject().toString()));
                }
                OidcUtils.setBlockinApiAttribute(builder, vertxContext);
                OidcUtils.setTenantIdAttribute(builder, resolvedContext.oidcConfig);
                return Uni.createFrom().item(builder.build());
            }
        });
    }

    @Deprecated
    private static boolean tokenAutoRefreshPrepared(JsonObject tokenJson, RoutingContext vertxContext, OidcTenantConfig oidcConfig) {
        if (tokenJson != null && oidcConfig.token.refreshExpired && (oidcConfig.token.getRefreshTokenTimeSkew().isPresent() || oidcConfig.token.autoRefreshInterval.isPresent()) && vertxContext.get(REFRESH_TOKEN_GRANT_RESPONSE) != Boolean.TRUE && vertxContext.get(NEW_AUTHENTICATION) != Boolean.TRUE) {
            long refreshTokenTimeSkew = oidcConfig.token.getRefreshTokenTimeSkew().orElse(oidcConfig.token.autoRefreshInterval.get()).getSeconds();
            long expiry = tokenJson.getLong("exp");
            long now = System.currentTimeMillis() / 1000L;
            return now + refreshTokenTimeSkew > expiry;
        }
        return false;
    }

    private static JsonObject getRolesJson(RoutingContext vertxContext, TenantConfigContext resolvedContext, TokenCredential tokenCred, JsonObject tokenJson, UserInfo userInfo) {
        JsonObject rolesJson = tokenJson;
        if (resolvedContext.oidcConfig.roles.source.isPresent()) {
            if (resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.userinfo) {
                rolesJson = new JsonObject(userInfo.getJsonObject().toString());
            } else if (tokenCred instanceof IdTokenCredential && resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.accesstoken && (rolesJson = ((TokenVerificationResult)vertxContext.get((String)CODE_ACCESS_TOKEN_RESULT)).localVerificationResult) == null) {
                rolesJson = OidcUtils.decodeJwtContent((String)vertxContext.get("access_token"));
            }
        }
        return rolesJson;
    }

    private Uni<TokenVerificationResult> verifyCodeFlowAccessTokenUni(RoutingContext vertxContext, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)vertxContext.get("access_token");
            return this.verifyTokenUni(resolvedContext, codeAccessToken);
        }
        return NULL_CODE_ACCESS_TOKEN_UNI;
    }

    private Uni<TokenVerificationResult> verifyTokenUni(TenantConfigContext resolvedContext, String token) {
        if (OidcUtils.isOpaqueToken(token)) {
            if (!resolvedContext.oidcConfig.token.allowOpaqueTokenIntrospection) {
                throw new AuthenticationFailedException();
            }
            return this.introspectTokenUni(resolvedContext, token);
        }
        if (resolvedContext.provider.getMetadata().getJsonWebKeySetUri() == null) {
            return this.introspectTokenUni(resolvedContext, token);
        }
        try {
            return Uni.createFrom().item(resolvedContext.provider.verifyJwtToken(token));
        }
        catch (Throwable t) {
            if (t.getCause() instanceof UnresolvableKeyException) {
                return this.refreshJwksAndVerifyTokenUni(resolvedContext, token);
            }
            return Uni.createFrom().failure(t);
        }
    }

    private Uni<TokenVerificationResult> refreshJwksAndVerifyTokenUni(TenantConfigContext resolvedContext, String token) {
        return resolvedContext.provider.refreshJwksAndVerifyJwtToken(token).onFailure(f -> f.getCause() instanceof UnresolvableKeyException && resolvedContext.oidcConfig.token.allowJwtIntrospection).recoverWithUni(f -> this.introspectTokenUni(resolvedContext, token));
    }

    private Uni<TokenVerificationResult> introspectTokenUni(TenantConfigContext resolvedContext, String token) {
        TokenIntrospectionCache tokenIntrospectionCache = this.tenantResolver.getTokenIntrospectionCache();
        Uni<TokenIntrospection> tokenIntrospectionUni = tokenIntrospectionCache == null ? null : tokenIntrospectionCache.getIntrospection(token, resolvedContext.oidcConfig, this.getIntrospectionRequestContext);
        tokenIntrospectionUni = tokenIntrospectionUni == null ? this.newTokenIntrospectionUni(resolvedContext, token) : tokenIntrospectionUni.onItem().ifNull().switchTo(this.newTokenIntrospectionUni(resolvedContext, token));
        return tokenIntrospectionUni.onItem().transform(t -> new TokenVerificationResult(null, (TokenIntrospection)t));
    }

    private Uni<TokenIntrospection> newTokenIntrospectionUni(final TenantConfigContext resolvedContext, final String token) {
        Uni<TokenIntrospection> tokenIntrospectionUni = resolvedContext.provider.introspectToken(token);
        if (this.tenantResolver.getTokenIntrospectionCache() == null || !resolvedContext.oidcConfig.allowTokenIntrospectionCache) {
            return tokenIntrospectionUni;
        }
        return tokenIntrospectionUni.call(new Function<TokenIntrospection, Uni<?>>(){

            @Override
            public Uni<?> apply(TokenIntrospection introspection) {
                return OidcIdentityProvider.this.tenantResolver.getTokenIntrospectionCache().addIntrospection(token, introspection, resolvedContext.oidcConfig, OidcIdentityProvider.this.uniVoidOidcContext);
            }
        });
    }

    private static Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        try {
            TokenVerificationResult result2 = resolvedContext.provider.verifyJwtToken(request.getToken().getToken());
            return Uni.createFrom().item(OidcUtils.validateAndCreateIdentity(null, request.getToken(), resolvedContext, result2.localVerificationResult, result2.localVerificationResult, null));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(new AuthenticationFailedException(t));
        }
    }

    private Uni<UserInfo> getUserInfoUni(RoutingContext vertxContext, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        UserInfoCache userInfoCache;
        String accessToken = (String)vertxContext.get("access_token");
        if (accessToken == null) {
            accessToken = request.getToken().getToken();
        }
        Uni<UserInfo> userInfoUni = (userInfoCache = this.tenantResolver.getUserInfoCache()) == null ? null : userInfoCache.getUserInfo(accessToken, resolvedContext.oidcConfig, this.getUserInfoRequestContext);
        userInfoUni = userInfoUni == null ? this.newUserInfoUni(resolvedContext, accessToken) : userInfoUni.onItem().ifNull().switchTo(this.newUserInfoUni(resolvedContext, accessToken));
        return userInfoUni;
    }

    private Uni<UserInfo> newUserInfoUni(final TenantConfigContext resolvedContext, final String accessToken) {
        Uni<UserInfo> userInfoUni = resolvedContext.provider.getUserInfo(accessToken);
        if (this.tenantResolver.getUserInfoCache() == null || !resolvedContext.oidcConfig.allowUserInfoCache) {
            return userInfoUni;
        }
        return userInfoUni.call(new Function<UserInfo, Uni<?>>(){

            @Override
            public Uni<?> apply(UserInfo userInfo) {
                return OidcIdentityProvider.this.tenantResolver.getUserInfoCache().addUserInfo(accessToken, userInfo, resolvedContext.oidcConfig, OidcIdentityProvider.this.uniVoidOidcContext);
            }
        });
    }
}

