/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SecurityCheckStorageBuilder {
    private final Map<MethodDescription, SecurityCheck> securityChecks = new HashMap<MethodDescription, SecurityCheck>();

    public void registerCheck(String className, String methodName, String[] parameterTypes, SecurityCheck securityCheck) {
        this.securityChecks.put(new MethodDescription(className, methodName, parameterTypes), securityCheck);
    }

    public SecurityCheckStorage create() {
        return new SecurityCheckStorage(){

            @Override
            public SecurityCheck getSecurityCheck(Method method) {
                MethodDescription descriptor = new MethodDescription(method.getDeclaringClass().getName(), method.getName(), SecurityCheckStorageBuilder.this.typesAsStrings(method.getParameterTypes()));
                return SecurityCheckStorageBuilder.this.securityChecks.get(descriptor);
            }
        };
    }

    private String[] typesAsStrings(Class<?>[] parameterTypes) {
        String[] result2 = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            result2[i] = parameterTypes[i].getName();
        }
        return result2;
    }

    static class MethodDescription {
        private final String className;
        private final String methodName;
        private final String[] parameterTypes;

        public MethodDescription(String className, String methodName, String[] parameterTypes) {
            this.className = className;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDescription that = (MethodDescription)o;
            return this.className.equals(that.className) && this.methodName.equals(that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            int result2 = Objects.hash(this.className, this.methodName);
            result2 = 31 * result2 + Arrays.hashCode(this.parameterTypes);
            return result2;
        }
    }
}

