/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;

public abstract class RouteHandler
implements Handler<RoutingContext> {
    private static final String REQUEST_CONTEXT_STATE = "__cdi_req_ctx";
    private final Event<SecurityIdentity> securityIdentityEvent = Arc.container().beanManager().getEvent().select(SecurityIdentity.class, new Annotation[0]);
    private final CurrentIdentityAssociation currentIdentityAssociation;
    private final CurrentVertxRequest currentVertxRequest = Arc.container().instance(CurrentVertxRequest.class, new Annotation[0]).get();
    private final ManagedContext requestContext = Arc.container().requestContext();

    public RouteHandler() {
        this.currentIdentityAssociation = Arc.container().instance(CurrentIdentityAssociation.class, new Annotation[0]).get();
    }

    public abstract void invoke(RoutingContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(RoutingContext context) {
        QuarkusHttpUser user = (QuarkusHttpUser)context.user();
        if (this.requestContext.isActive()) {
            if (this.currentIdentityAssociation != null) {
                if (user != null) {
                    SecurityIdentity identity = user.getSecurityIdentity();
                    this.currentIdentityAssociation.setIdentity(identity);
                } else {
                    this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity(context, null));
                }
            }
            if (user != null) {
                this.securityIdentityEvent.fire(user.getSecurityIdentity());
            }
            this.invoke(context);
        } else {
            try {
                InjectableContext.ContextState state = (InjectableContext.ContextState)context.get(REQUEST_CONTEXT_STATE);
                this.requestContext.activate(state);
                this.currentVertxRequest.setCurrent(context);
                if (this.currentIdentityAssociation != null) {
                    if (user != null) {
                        SecurityIdentity identity = user.getSecurityIdentity();
                        this.currentIdentityAssociation.setIdentity(identity);
                    } else {
                        this.currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity(context, null));
                    }
                }
                if (user != null) {
                    this.securityIdentityEvent.fire(user.getSecurityIdentity());
                }
                if (state == null) {
                    final InjectableContext.ContextState endState = this.requestContext.getState();
                    context.put(REQUEST_CONTEXT_STATE, endState);
                    context.addEndHandler(new Handler<AsyncResult<Void>>(){

                        @Override
                        public void handle(AsyncResult<Void> result2) {
                            RouteHandler.this.requestContext.destroy(endState);
                        }
                    });
                }
                this.invoke(context);
            }
            finally {
                this.requestContext.deactivate();
            }
        }
    }
}

