/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.vertx;

import io.smallrye.faulttolerance.core.util.RunnableWrapper;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.Executor;

final class VertxExecutor
implements Executor {
    private final Context vertxContext;

    VertxExecutor(Context vertxContext) {
        this.vertxContext = vertxContext;
    }

    @Override
    public void execute(Runnable runnable) {
        if (Vertx.currentContext() == this.vertxContext) {
            runnable.run();
            return;
        }
        Runnable wrappedRunnable = RunnableWrapper.INSTANCE.wrap(runnable);
        this.vertxContext.runOnContext(ignored -> wrappedRunnable.run());
    }
}

