/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.responses;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.MapModel;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class APIResponsesImpl
extends ExtensibleImpl<APIResponses>
implements APIResponses,
ModelImpl,
MapModel<APIResponse> {
    private Map<String, APIResponse> apiResponses;

    @Override
    public APIResponses addAPIResponse(String name, APIResponse apiResponse) {
        this.apiResponses = ModelUtil.add(name, apiResponse, this.apiResponses, LinkedHashMap::new);
        return this;
    }

    @Override
    public void removeAPIResponse(String name) {
        ModelUtil.remove(this.apiResponses, name);
    }

    @Override
    public Map<String, APIResponse> getAPIResponses() {
        return ModelUtil.unmodifiableMap(this.apiResponses);
    }

    @Override
    public void setAPIResponses(Map<String, APIResponse> items) {
        this.apiResponses = ModelUtil.replace(items, LinkedHashMap::new);
    }

    @Override
    public APIResponse getDefaultValue() {
        return this.getAPIResponse("default");
    }

    @Override
    public void setDefaultValue(APIResponse defaultValue) {
        if (defaultValue == null) {
            this.removeAPIResponse("default");
        } else {
            this.addAPIResponse("default", defaultValue);
        }
    }

    @Override
    public Map<String, APIResponse> getMap() {
        return this.apiResponses;
    }

    @Override
    public void setMap(Map<String, APIResponse> map) {
        this.apiResponses = map;
    }

    @Override
    public APIResponse get(Object key) {
        return (APIResponse)MapModel.super.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return MapModel.super.containsKey(key);
    }

    @Override
    public APIResponse put(String key, APIResponse value) {
        return MapModel.super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends APIResponse> m) {
        MapModel.super.putAll(m);
    }

    @Override
    public APIResponse remove(Object key) {
        return (APIResponse)MapModel.super.remove(key);
    }
}

