/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class FilterUtil {
    private FilterUtil() {
    }

    public static final OpenAPI applyFilter(OASFilter filter, OpenAPI model) {
        FilterUtil.filterComponents(filter, model.getComponents());
        if (model.getPaths() != null) {
            FilterUtil.filter(filter, model.getPaths().getPathItems(), FilterUtil::filterPathItem, filter::filterPathItem, model.getPaths()::removePathItem);
        }
        FilterUtil.filter(filter, model.getServers(), null, filter::filterServer, model::removeServer);
        FilterUtil.filter(filter, model.getTags(), null, filter::filterTag, model::removeTag);
        filter.filterOpenAPI(model);
        return model;
    }

    private static void filterComponents(OASFilter filter, Components model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getCallbacks(), FilterUtil::filterCallback, filter::filterCallback, model::removeCallback);
            FilterUtil.filter(filter, model.getHeaders(), FilterUtil::filterHeader, filter::filterHeader, model::removeHeader);
            FilterUtil.filter(filter, model.getLinks(), FilterUtil::filterLink, filter::filterLink, model::removeLink);
            FilterUtil.filter(filter, model.getParameters(), FilterUtil::filterParameter, filter::filterParameter, model::removeParameter);
            FilterUtil.filter(filter, model.getRequestBodies(), FilterUtil::filterRequestBody, filter::filterRequestBody, model::removeRequestBody);
            FilterUtil.filter(filter, model.getResponses(), FilterUtil::filterAPIResponse, filter::filterAPIResponse, model::removeResponse);
            FilterUtil.filter(filter, model.getSchemas(), FilterUtil::filterSchema, filter::filterSchema, model::removeSchema);
            FilterUtil.filter(filter, model.getSecuritySchemes(), null, filter::filterSecurityScheme, model::removeSecurityScheme);
        }
    }

    private static <K, V> void filter(OASFilter filter, Map<K, V> models, BiConsumer<OASFilter, V> contentFilter, UnaryOperator<V> modelFilter, Consumer<K> remover) {
        if (models != null) {
            for (Map.Entry entry : new LinkedHashSet<Map.Entry<K, V>>(models.entrySet())) {
                Object model = entry.getValue();
                if (contentFilter != null) {
                    contentFilter.accept(filter, model);
                }
                if (modelFilter.apply(model) != null) continue;
                remover.accept(entry.getKey());
            }
        }
    }

    private static <T> void filter(OASFilter filter, List<T> models, BiConsumer<OASFilter, T> contentFilter, UnaryOperator<T> modelFilter, Consumer<T> remover) {
        if (models != null) {
            for (T model : new ArrayList<T>(models)) {
                if (contentFilter != null) {
                    contentFilter.accept(filter, (OASFilter)model);
                }
                if (modelFilter.apply(model) != null) continue;
                remover.accept(model);
            }
        }
    }

    private static <T> void filter(OASFilter filter, T model, BiConsumer<OASFilter, T> contentFilter, UnaryOperator<T> modelFilter, Consumer<T> mutator) {
        if (model != null) {
            if (contentFilter != null) {
                contentFilter.accept(filter, (OASFilter)model);
            }
            mutator.accept(modelFilter.apply(model));
        }
    }

    private static void filterCallback(OASFilter filter, Callback model) {
        if (model != null) {
            ArrayList<String> keys = new ArrayList<String>(model.getPathItems().keySet());
            for (String key : keys) {
                PathItem childModel = model.getPathItem(key);
                FilterUtil.filterPathItem(filter, childModel);
                if (filter.filterPathItem(childModel) != null) continue;
                model.removePathItem(key);
            }
        }
    }

    private static void filterPathItem(OASFilter filter, PathItem model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getParameters(), FilterUtil::filterParameter, filter::filterParameter, model::removeParameter);
            FilterUtil.filterOperation(filter, model.getDELETE(), model::setDELETE);
            FilterUtil.filterOperation(filter, model.getGET(), model::setGET);
            FilterUtil.filterOperation(filter, model.getHEAD(), model::setHEAD);
            FilterUtil.filterOperation(filter, model.getOPTIONS(), model::setOPTIONS);
            FilterUtil.filterOperation(filter, model.getPATCH(), model::setPATCH);
            FilterUtil.filterOperation(filter, model.getPOST(), model::setPOST);
            FilterUtil.filterOperation(filter, model.getPUT(), model::setPUT);
            FilterUtil.filterOperation(filter, model.getTRACE(), model::setTRACE);
            FilterUtil.filter(filter, model.getServers(), null, filter::filterServer, model::removeServer);
        }
    }

    private static void filterOperation(OASFilter filter, Operation model, Consumer<Operation> mutator) {
        if (model != null) {
            FilterUtil.filter(filter, model.getCallbacks(), FilterUtil::filterCallback, filter::filterCallback, model::removeCallback);
            FilterUtil.filter(filter, model.getParameters(), FilterUtil::filterParameter, filter::filterParameter, model::removeParameter);
            FilterUtil.filter(filter, model.getRequestBody(), FilterUtil::filterRequestBody, filter::filterRequestBody, model::setRequestBody);
            if (model.getResponses() != null) {
                APIResponses responses = model.getResponses();
                FilterUtil.filter(filter, responses.getAPIResponses(), FilterUtil::filterAPIResponse, filter::filterAPIResponse, responses::removeAPIResponse);
            }
            FilterUtil.filter(filter, model.getServers(), null, filter::filterServer, model::removeServer);
            mutator.accept(filter.filterOperation(model));
        }
    }

    private static void filterHeader(OASFilter filter, Header model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filter(filter, model.getSchema(), FilterUtil::filterSchema, filter::filterSchema, model::setSchema);
        }
    }

    private static void filterContent(OASFilter filter, Content model) {
        if (model != null && model.getMediaTypes() != null) {
            ArrayList<String> keys = new ArrayList<String>(model.getMediaTypes().keySet());
            for (String key : keys) {
                MediaType childModel = model.getMediaType(key);
                FilterUtil.filterMediaType(filter, childModel);
            }
        }
    }

    private static void filterMediaType(OASFilter filter, MediaType model) {
        if (model != null) {
            FilterUtil.filterEncoding(filter, model.getEncoding());
            FilterUtil.filter(filter, model.getSchema(), FilterUtil::filterSchema, filter::filterSchema, model::setSchema);
        }
    }

    private static void filterEncoding(OASFilter filter, Map<String, Encoding> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Encoding model = models.get(key);
                FilterUtil.filterEncoding(filter, model);
            }
        }
    }

    private static void filterEncoding(OASFilter filter, Encoding model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getHeaders(), FilterUtil::filterHeader, filter::filterHeader, model::removeHeader);
        }
    }

    private static void filterLink(OASFilter filter, Link model) {
        if (model != null && model.getServer() != null) {
            model.setServer(filter.filterServer(model.getServer()));
        }
    }

    private static void filterParameter(OASFilter filter, Parameter model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filter(filter, model.getSchema(), FilterUtil::filterSchema, filter::filterSchema, model::setSchema);
        }
    }

    private static void filterRequestBody(OASFilter filter, RequestBody model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
        }
    }

    private static void filterAPIResponse(OASFilter filter, APIResponse model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filter(filter, model.getHeaders(), FilterUtil::filterHeader, filter::filterHeader, model::removeHeader);
            FilterUtil.filter(filter, model.getLinks(), FilterUtil::filterLink, filter::filterLink, model::removeLink);
        }
    }

    private static void filterSchema(OASFilter filter, Schema model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getAdditionalPropertiesSchema(), FilterUtil::filterSchema, filter::filterSchema, model::setAdditionalPropertiesSchema);
            FilterUtil.filter(filter, model.getAllOf(), FilterUtil::filterSchema, filter::filterSchema, model::removeAllOf);
            FilterUtil.filter(filter, model.getAnyOf(), FilterUtil::filterSchema, filter::filterSchema, model::removeAnyOf);
            FilterUtil.filter(filter, model.getItems(), FilterUtil::filterSchema, filter::filterSchema, model::setItems);
            FilterUtil.filter(filter, model.getNot(), FilterUtil::filterSchema, filter::filterSchema, model::setNot);
            FilterUtil.filter(filter, model.getProperties(), FilterUtil::filterSchema, filter::filterSchema, model::removeProperty);
        }
    }
}

