/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.api.util.UtilLogging;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class MergeUtil {
    private static final Set<String> EXCLUDED_PROPERTIES = new HashSet<String>();

    private MergeUtil() {
    }

    public static final OpenAPI merge(OpenAPI document1, OpenAPI document2) {
        return MergeUtil.mergeObjects(document1, document2);
    }

    public static <T> T mergeObjects(T object1, T object2) {
        if (object1 == null && object2 != null) {
            return object2;
        }
        if (object1 != null && object2 == null) {
            return object1;
        }
        if (object1 == null && object2 == null) {
            return null;
        }
        if (!object1.getClass().equals(object2.getClass())) {
            return object2;
        }
        PropertyDescriptor[] descriptors = new PropertyDescriptor[]{};
        try {
            descriptors = Introspector.getBeanInfo(object1.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            UtilLogging.logger.failedToIntrospectBeanInfo(object1.getClass(), e);
        }
        for (PropertyDescriptor descriptor : descriptors) {
            Object newValues;
            Object values2;
            Object values1;
            if (EXCLUDED_PROPERTIES.contains(descriptor.getName())) continue;
            Class<?> ptype = descriptor.getPropertyType();
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) continue;
            if (Constructible.class.isAssignableFrom(ptype)) {
                try {
                    Object val1 = descriptor.getReadMethod().invoke(object1, new Object[0]);
                    Object val2 = descriptor.getReadMethod().invoke(object2, new Object[0]);
                    Object newValue = MergeUtil.mergeObjects(val1, val2);
                    if (newValue == null) continue;
                    writeMethod.invoke(object1, newValue);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (Map.class.isAssignableFrom(ptype)) {
                try {
                    values1 = (Map)descriptor.getReadMethod().invoke(object1, new Object[0]);
                    values2 = (Map)descriptor.getReadMethod().invoke(object2, new Object[0]);
                    newValues = MergeUtil.mergeMaps((Map)values1, (Map)values2);
                    writeMethod.invoke(object1, newValues);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (List.class.isAssignableFrom(ptype)) {
                try {
                    values1 = (List)descriptor.getReadMethod().invoke(object1, new Object[0]);
                    values2 = (List)descriptor.getReadMethod().invoke(object2, new Object[0]);
                    newValues = MergeUtil.mergeLists((List)values1, (List)values2).orElse(null);
                    writeMethod.invoke(object1, newValues);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Object newValue = descriptor.getReadMethod().invoke(object2, new Object[0]);
                if (newValue == null) continue;
                writeMethod.invoke(object1, newValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return object1;
    }

    private static Map mergeMaps(Map values1, Map values2) {
        if (values1 == null && values2 == null) {
            return null;
        }
        if (values1 != null && values2 == null) {
            return values1;
        }
        if (values1 == null && values2 != null) {
            return values2;
        }
        if (!(values1 instanceof ModelImpl)) {
            values1 = new LinkedHashMap(values1);
        }
        if (!(values2 instanceof ModelImpl)) {
            values2 = new LinkedHashMap(values2);
        }
        for (Object key : values2.keySet()) {
            if (values1.containsKey(key)) {
                Object pval1 = values1.get(key);
                Object pval2 = values2.get(key);
                if (pval1 instanceof Map) {
                    values1.put(key, MergeUtil.mergeMaps((Map)pval1, (Map)pval2));
                    continue;
                }
                if (pval1 instanceof List) {
                    values1.put(key, MergeUtil.mergeLists((List)pval1, (List)pval2).orElse(null));
                    continue;
                }
                if (pval1 instanceof Constructible) {
                    values1.put(key, MergeUtil.mergeObjects(pval1, pval2));
                    continue;
                }
                values1.put(key, pval2);
                continue;
            }
            Object pval2 = values2.get(key);
            values1.put(key, pval2);
        }
        if (values1 instanceof Constructible) {
            if (values1 instanceof Reference) {
                Reference ref1 = (Reference)((Object)values1);
                Reference ref2 = (Reference)((Object)values2);
                if (ref2.getRef() != null) {
                    ref1.setRef(ref2.getRef());
                }
            }
            if (values1 instanceof Extensible) {
                Extensible extensible1 = (Extensible)((Object)values1);
                Extensible extensible2 = (Extensible)((Object)values2);
                extensible1.setExtensions(MergeUtil.mergeMaps(extensible1.getExtensions(), extensible2.getExtensions()));
            }
            if (values1 instanceof APIResponses) {
                APIResponses responses1 = (APIResponses)((Object)values1);
                APIResponses responses2 = (APIResponses)((Object)values2);
                responses1.defaultValue(MergeUtil.mergeObjects(responses1.getDefaultValue(), responses2.getDefaultValue()));
            }
        }
        return values1;
    }

    private static Optional<List> mergeLists(List values1, List values2) {
        if (values1 == null && values2 == null) {
            return Optional.empty();
        }
        if (values1 != null && values2 == null) {
            return Optional.of(values1);
        }
        if ((values1 == null || values1.isEmpty()) && values2 != null) {
            return Optional.of(values2);
        }
        if (values1.equals(values2)) {
            return Optional.of(values1);
        }
        if (values1.get(0) instanceof String) {
            return Optional.of(MergeUtil.mergeStringLists(values1, values2));
        }
        if (values1.get(0) instanceof Tag) {
            return Optional.of(MergeUtil.mergeTagLists(values1, values2));
        }
        if (values1.get(0) instanceof Server) {
            return Optional.of(MergeUtil.mergeServerLists(values1, values2));
        }
        if (values1.get(0) instanceof SecurityRequirement) {
            return Optional.of(MergeUtil.mergeSecurityRequirementLists(values1, values2));
        }
        if (values1.get(0) instanceof Parameter) {
            return Optional.of(MergeUtil.mergeParameterLists(values1, values2));
        }
        ArrayList merged = new ArrayList(values1.size() + values2.size());
        merged.addAll(values1);
        merged.addAll(values2);
        return Optional.of(merged);
    }

    private static List<String> mergeStringLists(List<String> values1, List<String> values2) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(values1);
        set.addAll(values2);
        return new ArrayList<String>(set);
    }

    private static List<Tag> mergeTagLists(List<Tag> values1, List<Tag> values2) {
        values1 = new ArrayList<Tag>(values1);
        for (Tag value2 : values2) {
            Tag match = null;
            for (Tag value1 : values1) {
                if (value1.getName() == null || !value1.getName().equals(value2.getName())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            MergeUtil.mergeObjects(match, value2);
        }
        return values1;
    }

    private static List<Server> mergeServerLists(List<Server> values1, List<Server> values2) {
        values1 = new ArrayList<Server>(values1);
        for (Server value2 : values2) {
            Server match = null;
            for (Server value1 : values1) {
                if (value1.getUrl() == null || !value1.getUrl().equals(value2.getUrl())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            MergeUtil.mergeObjects(match, value2);
        }
        return values1;
    }

    private static List<SecurityRequirement> mergeSecurityRequirementLists(List<SecurityRequirement> values1, List<SecurityRequirement> values2) {
        values1 = new ArrayList<SecurityRequirement>(values1);
        for (SecurityRequirement value2 : values2) {
            if (values1.contains(value2)) continue;
            values1.add(value2);
        }
        return values1;
    }

    private static List<Parameter> mergeParameterLists(List<Parameter> values1, List<Parameter> values2) {
        values1 = new ArrayList<Parameter>(values1);
        for (Parameter value2 : values2) {
            Parameter match = null;
            for (Parameter value1 : values1) {
                if (value1.getName() == null || !value1.getName().equals(value2.getName()) || value1.getIn() == null || !value1.getIn().equals((Object)value2.getIn())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            MergeUtil.mergeObjects(match, value2);
        }
        return values1;
    }

    static {
        EXCLUDED_PROPERTIES.add("class");
        EXCLUDED_PROPERTIES.add("openapi");
    }
}

