/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class AnnotationTargetProcessor
implements BeanValidationScanner.RequirementHandler {
    private final AnnotationScannerContext context;
    private final DataObjectDeque objectStack;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final TypeResolver typeResolver;
    private final Type entityType;
    private final AnnotationTarget annotationTarget;

    private AnnotationTargetProcessor(AnnotationScannerContext context, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, AnnotationTarget annotationTarget, Type entityType) {
        this.context = context;
        this.objectStack = objectStack;
        this.parentPathEntry = parentPathEntry;
        this.typeResolver = typeResolver;
        this.entityType = entityType;
        this.annotationTarget = annotationTarget;
    }

    public static Schema process(AnnotationScannerContext context, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(context, objectStack, parentPathEntry, typeResolver, typeResolver.getAnnotationTarget(), typeResolver.getUnresolvedType());
        return fp.processField();
    }

    public static Schema process(AnnotationScannerContext context, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(context, objectStack, parentPathEntry, typeResolver, context.getAugmentedIndex().getClass(type), type);
        return fp.processField();
    }

    @Override
    public void setRequired(AnnotationTarget target, String propertyKey) {
        AnnotationInstance schemaAnnotation;
        List<String> requiredProperties = this.parentPathEntry.getSchema().getRequired();
        if (!(requiredProperties != null && requiredProperties.contains(propertyKey) || (schemaAnnotation = TypeUtil.getSchemaAnnotation(target)) != null && schemaAnnotation.value("required") != null)) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
    }

    Schema processField() {
        Type fieldType;
        Schema registeredTypeSchema;
        Schema typeSchema;
        AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(this.annotationTarget);
        String propertyKey = this.typeResolver.getPropertyName();
        if (schemaAnnotation != null && JandexUtil.hasImplementation(schemaAnnotation)) {
            typeSchema = null;
            registeredTypeSchema = null;
            fieldType = (Type)JandexUtil.value(schemaAnnotation, "implementation");
        } else {
            TypeProcessor typeProcessor = new TypeProcessor(this.context, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, new SchemaImpl(), this.annotationTarget);
            fieldType = typeProcessor.processType();
            typeSchema = typeProcessor.getSchema();
            if (!TypeUtil.isTypeOverridden(fieldType, schemaAnnotation)) {
                TypeUtil.applyTypeAttributes(fieldType, typeSchema);
            }
            Type registrationType = TypeUtil.isWrappedType(this.entityType) ? fieldType : this.entityType;
            registeredTypeSchema = typeSchema.getType() != Schema.SchemaType.ARRAY ? SchemaRegistry.registerReference(registrationType, this.typeResolver, typeSchema) : SchemaRegistry.checkRegistration(registrationType, this.typeResolver, typeSchema);
        }
        Schema fieldSchema = schemaAnnotation != null ? this.readSchemaAnnotatedField(propertyKey, schemaAnnotation, fieldType) : (this.registrationSuccessful(typeSchema, registeredTypeSchema) ? new SchemaImpl().type(typeSchema.getType()) : MergeUtil.mergeObjects(new SchemaImpl(), typeSchema));
        for (AnnotationTarget contraintTarget : this.typeResolver.getConstraintTargets()) {
            BeanValidationScanner.applyConstraints(contraintTarget, fieldSchema, propertyKey, this);
        }
        if (fieldSchema.getNullable() == null && TypeUtil.isOptional(this.entityType)) {
            fieldSchema.setNullable(Boolean.TRUE);
        }
        this.processFieldAnnotations(fieldSchema, this.typeResolver);
        Schema parentSchema = this.parentPathEntry.getSchema();
        Schema existingFieldSchema = ModelUtil.getPropertySchema(parentSchema, propertyKey);
        if (existingFieldSchema != null) {
            fieldSchema = MergeUtil.mergeObjects(fieldSchema, existingFieldSchema);
        }
        if (this.registrationSuccessful(typeSchema, registeredTypeSchema)) {
            if (this.fieldOverridesType(fieldSchema, typeSchema)) {
                TypeUtil.clearMatchingDefaultAttributes(fieldSchema, typeSchema);
                SchemaImpl composition = new SchemaImpl();
                composition.addAllOf(registeredTypeSchema);
                composition.addAllOf(fieldSchema);
                fieldSchema = composition;
            } else {
                fieldSchema = registeredTypeSchema;
            }
        } else {
            fieldSchema = MergeUtil.mergeObjects(typeSchema, fieldSchema);
        }
        parentSchema.addProperty(propertyKey, fieldSchema);
        return fieldSchema;
    }

    private void processFieldAnnotations(Schema fieldSchema, TypeResolver typeResolver) {
        String name = typeResolver.getBeanPropertyName();
        FieldInfo field2 = typeResolver.getField();
        if (field2 != null && this.processXmlAttr(name, fieldSchema, JandexUtil.getAnnotation(field2, JaxbConstants.XML_ATTRIBUTE), JandexUtil.getAnnotation(field2, JaxbConstants.XML_ELEMENT), JandexUtil.getAnnotation(field2, JaxbConstants.XML_WRAPPERELEMENT))) {
            return;
        }
        MethodInfo readMethod = typeResolver.getReadMethod();
        if (readMethod != null && this.processXmlAttr(name, fieldSchema, JandexUtil.getAnnotation(readMethod, JaxbConstants.XML_ATTRIBUTE), JandexUtil.getAnnotation(readMethod, JaxbConstants.XML_ELEMENT), JandexUtil.getAnnotation(readMethod, JaxbConstants.XML_WRAPPERELEMENT))) {
            return;
        }
        MethodInfo writeMethod = typeResolver.getWriteMethod();
        if (writeMethod != null && this.processXmlAttr(name, fieldSchema, JandexUtil.getAnnotation(writeMethod, JaxbConstants.XML_ATTRIBUTE), JandexUtil.getAnnotation(writeMethod, JaxbConstants.XML_ELEMENT), JandexUtil.getAnnotation(writeMethod, JaxbConstants.XML_WRAPPERELEMENT))) {
            return;
        }
    }

    private boolean processXmlAttr(String name, Schema fieldSchema, AnnotationInstance xmlAttr, AnnotationInstance xmlElement, AnnotationInstance xmlWrapper) {
        if (xmlAttr == null && xmlWrapper == null && xmlElement == null) {
            return false;
        }
        if (xmlAttr != null) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().attribute(true);
            this.setXmlName(fieldSchema, name, xmlAttr);
        }
        if (xmlWrapper != null) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().wrapped(true);
            this.setXmlName(fieldSchema, name, xmlWrapper);
            if (xmlElement != null) {
                this.setXmlName(fieldSchema.getItems(), name, xmlElement);
                return true;
            }
        }
        if (xmlElement != null) {
            this.setXmlName(fieldSchema, name, xmlElement);
        }
        return true;
    }

    private void setXmlIfEmpty(Schema schema) {
        if (schema.getXml() != null) {
            return;
        }
        schema.setXml(new XMLImpl());
    }

    private void setXmlName(Schema fieldSchema, String realName, AnnotationInstance xmlAttr) {
        String annName;
        AnnotationValue name = xmlAttr.value("name");
        if (fieldSchema != null && name != null && !(annName = name.asString()).equals(realName)) {
            this.setXmlIfEmpty(fieldSchema);
            fieldSchema.getXml().name(annName);
        }
    }

    private boolean registrationSuccessful(Schema typeSchema, Schema registeredTypeSchema) {
        return typeSchema != registeredTypeSchema;
    }

    private Schema readSchemaAnnotatedField(String propertyKey, AnnotationInstance annotation, Type postProcessedField) {
        DataObjectLogging.logger.processingFieldAnnotation(annotation, propertyKey);
        if (JandexUtil.booleanValueWithDefault(annotation, "required")) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
        Map<Object, Object> defaults = JandexUtil.isArraySchema(annotation) || TypeUtil.isTypeOverridden(postProcessedField, annotation) ? Collections.emptyMap() : TypeUtil.getTypeAttributes(postProcessedField);
        return SchemaFactory.readSchema(this.context, (Schema)new SchemaImpl(), annotation, defaults);
    }

    boolean fieldOverridesType(Schema fieldSchema, Schema typeSchema) {
        List<Supplier<Object>> typeAttributes = this.getAttributeSuppliers(typeSchema);
        List<Supplier<Object>> fieldAttributes = this.getAttributeSuppliers(fieldSchema);
        int m = typeAttributes.size();
        for (int i = 0; i < m; ++i) {
            Object typeAttr;
            Object fieldAttr = fieldAttributes.get(i).get();
            if (fieldAttr == null || (typeAttr = typeAttributes.get(i).get()) != null && fieldAttr.equals(typeAttr)) continue;
            return true;
        }
        return false;
    }

    List<Supplier<Object>> getAttributeSuppliers(Schema schema) {
        Supplier[] supplierArray = new Supplier[38];
        supplierArray[0] = schema::getAdditionalPropertiesBoolean;
        supplierArray[1] = schema::getAdditionalPropertiesSchema;
        supplierArray[2] = schema::getAllOf;
        supplierArray[3] = schema::getAnyOf;
        supplierArray[4] = schema::getDefaultValue;
        supplierArray[5] = schema::getDeprecated;
        supplierArray[6] = schema::getDescription;
        supplierArray[7] = schema::getDiscriminator;
        supplierArray[8] = schema::getEnumeration;
        supplierArray[9] = schema::getExample;
        supplierArray[10] = schema::getExclusiveMaximum;
        supplierArray[11] = schema::getExclusiveMinimum;
        supplierArray[12] = schema::getExtensions;
        supplierArray[13] = schema::getExternalDocs;
        supplierArray[14] = schema::getFormat;
        supplierArray[15] = schema::getItems;
        supplierArray[16] = schema::getMaximum;
        supplierArray[17] = schema::getMaxItems;
        supplierArray[18] = schema::getMaxLength;
        supplierArray[19] = schema::getMaxProperties;
        supplierArray[20] = schema::getMinimum;
        supplierArray[21] = schema::getMinItems;
        supplierArray[22] = schema::getMinLength;
        supplierArray[23] = schema::getMinProperties;
        supplierArray[24] = schema::getMultipleOf;
        supplierArray[25] = schema::getNot;
        supplierArray[26] = schema::getNullable;
        supplierArray[27] = schema::getOneOf;
        supplierArray[28] = schema::getPattern;
        supplierArray[29] = schema::getProperties;
        supplierArray[30] = schema::getReadOnly;
        supplierArray[31] = schema::getRef;
        supplierArray[32] = schema::getRequired;
        supplierArray[33] = schema::getTitle;
        supplierArray[34] = schema::getType;
        supplierArray[35] = schema::getUniqueItems;
        supplierArray[36] = schema::getWriteOnly;
        supplierArray[37] = schema::getXml;
        return Arrays.asList(supplierArray);
    }
}

