/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.future.FutureImpl;
import java.util.function.Function;

public class CompositeFutureImpl
extends FutureImpl<CompositeFuture>
implements CompositeFuture {
    private static final Function<CompositeFuture, Object> ALL = cf -> {
        int size = cf.size();
        for (int i = 0; i < size; ++i) {
            if (cf.succeeded(i)) continue;
            return cf.cause(i);
        }
        return cf;
    };
    private final Future[] results;
    private int count;

    public static CompositeFuture all(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result2 : results) {
            result2.onComplete((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len || ++composite.count != len) {
                            return;
                        }
                    }
                    composite.trySucceed();
                } else {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len) {
                            return;
                        }
                        composite.count = len;
                    }
                    composite.tryFail(ar.cause());
                }
            });
        }
        if (len == 0) {
            composite.trySucceed();
        }
        return composite;
    }

    public static CompositeFuture any(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result2 : results) {
            result2.onComplete((AsyncResult<T> ar) -> {
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len) {
                            return;
                        }
                        composite.count = len;
                    }
                    composite.trySucceed();
                } else {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (composite.count == len || ++composite.count != len) {
                            return;
                        }
                    }
                    composite.tryFail(ar.cause());
                }
            });
        }
        if (results.length == 0) {
            composite.trySucceed();
        }
        return composite;
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.join(ALL, results);
    }

    private static CompositeFuture join(Function<CompositeFuture, Object> pred, Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (Future<?> result2 : results) {
            result2.onComplete((AsyncResult<T> ar) -> {
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    if (++composite.count < len) {
                        return;
                    }
                }
                composite.complete(pred.apply(composite));
            });
        }
        if (len == 0) {
            composite.trySucceed();
        }
        return composite;
    }

    private CompositeFutureImpl(Future<?> ... results) {
        this.results = results;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.future(index).result();
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index >= this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    private void trySucceed() {
        this.tryComplete(this);
    }

    private void fail(Throwable t) {
        this.complete(t);
    }

    private void complete(Object result2) {
        if (result2 == this) {
            this.tryComplete(this);
        } else if (result2 instanceof Throwable) {
            this.tryFail((Throwable)result2);
        }
    }

    @Override
    public CompositeFuture onComplete(Handler<AsyncResult<CompositeFuture>> handler) {
        return (CompositeFuture)super.onComplete(handler);
    }

    @Override
    public CompositeFuture onSuccess(Handler<CompositeFuture> handler) {
        return (CompositeFuture)super.onSuccess(handler);
    }

    @Override
    public CompositeFuture onFailure(Handler<Throwable> handler) {
        return (CompositeFuture)super.onFailure(handler);
    }

    @Override
    protected void formatValue(Object value, StringBuilder sb) {
        sb.append('(');
        for (int i = 0; i < this.results.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.results[i]);
        }
        sb.append(')');
    }
}

