/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.pool.CombinerExecutor;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Executor;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnection;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.net.impl.pool.PoolWaiter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class SimpleConnectionPool<C>
implements ConnectionPool<C> {
    private static final Future POOL_CLOSED = Future.failedFuture("Pool closed");
    private static final BiFunction<PoolWaiter, List<PoolConnection>, PoolConnection> SAME_CONTEXT_SELECTOR = (waiter, list) -> {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            PoolConnection slot = (PoolConnection)list.get(i);
            if (slot.context() != waiter.context() || slot.concurrency() <= 0) continue;
            return slot;
        }
        return null;
    };
    private static final BiFunction<PoolWaiter, List<PoolConnection>, PoolConnection> FIRST_AVAILABLE_SELECTOR = (waiter, list) -> {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            PoolConnection slot = (PoolConnection)list.get(i);
            if (slot.concurrency() <= 0) continue;
            return slot;
        }
        return null;
    };
    private final PoolConnector<C> connector;
    private final int maxWaiters;
    private final int maxCapacity;
    private final int[] capacityFactors;
    private final Executor<SimpleConnectionPool<C>> sync;
    private final ListImpl list = new ListImpl();
    private boolean closed;
    private BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> selector;
    private BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> fallbackSelector;
    private final Slot<C>[] slots;
    private int size;
    private int capacity;
    private final Waiters<C> waiters;
    private int requests;

    SimpleConnectionPool(PoolConnector<C> connector, int[] maxSizes) {
        this(connector, maxSizes, -1);
    }

    SimpleConnectionPool(PoolConnector<C> connector, int[] maxSizes, int maxWaiters) {
        int i;
        int[] capacities = new int[maxSizes.length];
        int maxCapacity = 1;
        int numSlots = 0;
        for (i = 0; i < maxSizes.length; ++i) {
            int maxSize = maxSizes[i];
            if (maxSize < 1) {
                throw new IllegalArgumentException();
            }
            maxCapacity *= maxSize;
            numSlots = Math.max(numSlots, maxSize);
        }
        for (i = 0; i < maxSizes.length; ++i) {
            capacities[i] = maxCapacity / maxSizes[i];
        }
        this.capacityFactors = capacities;
        this.connector = connector;
        this.slots = new Slot[numSlots];
        this.size = 0;
        this.maxWaiters = maxWaiters;
        this.capacity = 0;
        this.maxCapacity = maxCapacity;
        this.sync = new CombinerExecutor<SimpleConnectionPool>(this);
        this.selector = SAME_CONTEXT_SELECTOR;
        this.fallbackSelector = FIRST_AVAILABLE_SELECTOR;
        this.waiters = new Waiters();
    }

    @Override
    public ConnectionPool<C> connectionSelector(BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> selector) {
        this.selector = selector;
        return this;
    }

    private void execute(Executor.Action<SimpleConnectionPool<C>> action) {
        this.sync.submit(action);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void connect(Slot<C> slot, PoolWaiter<C> waiter) {
        ((Slot)slot).initiator = waiter;
        this.connector.connect(((Slot)slot).context, slot, ar -> {
            ((Slot)slot).initiator = null;
            if (ar.succeeded()) {
                this.execute(new ConnectSuccess(slot, (ConnectResult)ar.result(), waiter));
            } else {
                this.execute(new ConnectFailed(slot, ar.cause(), waiter));
            }
        });
    }

    private void setConcurrency(Slot<C> slot, long concurrency) {
        this.execute(new SetConcurrency<C>(slot, concurrency));
    }

    private void remove(Slot<C> removed) {
        this.execute(new Remove(removed));
    }

    @Override
    public void evict(Predicate<C> predicate, Handler<AsyncResult<List<C>>> handler) {
        this.execute(new Evict<C>(predicate, handler));
    }

    @Override
    public void acquire(EventLoopContext context, PoolWaiter.Listener<C> listener, int kind, Handler<AsyncResult<Lease<C>>> handler) {
        this.execute(new Acquire<C>(context, listener, this.capacityFactors[kind], handler));
    }

    @Override
    public void acquire(EventLoopContext context, int kind, Handler<AsyncResult<Lease<C>>> handler) {
        this.acquire(context, PoolWaiter.NULL_LISTENER, kind, handler);
    }

    @Override
    public void cancel(PoolWaiter<C> waiter, Handler<AsyncResult<Boolean>> handler) {
        this.execute(new Cancel<C>(waiter, handler));
    }

    private void recycle(LeaseImpl<C> lease) {
        if (((LeaseImpl)lease).recycled) {
            throw new IllegalStateException("Attempt to recycle more than permitted");
        }
        ((LeaseImpl)lease).recycled = true;
        this.execute(new Recycle(((LeaseImpl)lease).slot));
    }

    @Override
    public int waiters() {
        return this.waiters.size();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int requests() {
        return this.requests;
    }

    @Override
    public void close(Handler<AsyncResult<List<Future<C>>>> handler) {
        this.execute(new Close(handler));
    }

    class ListImpl
    extends AbstractList<PoolConnection<C>> {
        ListImpl() {
        }

        @Override
        public PoolConnection<C> get(int index) {
            return SimpleConnectionPool.this.slots[index];
        }

        @Override
        public int size() {
            return SimpleConnectionPool.this.size;
        }
    }

    private static class Waiters<C>
    implements Iterable<PoolWaiter<C>> {
        private final PoolWaiter<C> head = new PoolWaiter(null, null, 0, null);
        private int size;

        public Waiters() {
            this.head.prev = this.head;
            this.head.next = this.head.prev;
        }

        PoolWaiter<C> poll() {
            if (this.head.next == this.head) {
                return null;
            }
            PoolWaiter node = this.head.next;
            this.removeFirst(node);
            return node;
        }

        void addLast(PoolWaiter<C> node) {
            node.prev = this.head.prev;
            node.next = this.head;
            this.head.prev.next = node;
            this.head.prev = node;
            ++this.size;
        }

        void addFirst(PoolWaiter<C> node) {
            node.prev = this.head;
            node.next = this.head.prev;
            this.head.next.prev = node;
            this.head.next = node;
            ++this.size;
        }

        boolean removeFirst(PoolWaiter<C> node) {
            if (node.next == null) {
                return false;
            }
            node.next.prev = node.prev;
            node.prev.next = node.next;
            --this.size;
            return true;
        }

        List<PoolWaiter<C>> clear() {
            ArrayList<PoolWaiter<C>> lst = new ArrayList<PoolWaiter<C>>(this.size);
            this.forEach(lst::add);
            this.size = 0;
            this.head.prev = this.head;
            this.head.next = this.head.prev;
            return lst;
        }

        int size() {
            return this.size;
        }

        @Override
        public Iterator<PoolWaiter<C>> iterator() {
            return new Iterator<PoolWaiter<C>>(){
                PoolWaiter<C> current;
                {
                    this.current = head;
                }

                @Override
                public boolean hasNext() {
                    return this.current.next != head;
                }

                @Override
                public PoolWaiter<C> next() {
                    if (this.current.next == head) {
                        throw new NoSuchElementException();
                    }
                    try {
                        PoolWaiter poolWaiter = this.current.next;
                        return poolWaiter;
                    }
                    finally {
                        this.current = this.current.next;
                    }
                }
            };
        }
    }

    private static class Close<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Handler<AsyncResult<List<Future<C>>>> handler;

        private Close(Handler<AsyncResult<List<Future<C>>>> handler) {
            this.handler = handler;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return () -> this.handler.handle(POOL_CLOSED);
            }
            ((SimpleConnectionPool)pool).closed = true;
            List waiters = ((SimpleConnectionPool)pool).waiters.clear();
            ArrayList list = new ArrayList();
            for (int i = 0; i < ((SimpleConnectionPool)pool).size; ++i) {
                Slot slot = ((SimpleConnectionPool)pool).slots[i];
                ((SimpleConnectionPool)pool).slots[i] = null;
                if (slot.initiator != null) {
                    waiters.add(slot.initiator);
                    slot.initiator = null;
                }
                SimpleConnectionPool<C> simpleConnectionPool = pool;
                ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity - slot.capacity;
                list.add(slot.result.future());
            }
            ((SimpleConnectionPool)pool).size = 0;
            return () -> {
                waiters.forEach(w -> w.context.emit(POOL_CLOSED, w.handler));
                this.handler.handle(Future.succeededFuture(list));
            };
        }
    }

    private static class Recycle<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;

        public Recycle(Slot<C> slot) {
            this.slot = slot;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (!((SimpleConnectionPool)pool).closed && ((Slot)this.slot).connection != null) {
                if (((SimpleConnectionPool)pool).waiters.size() > 0) {
                    PoolWaiter waiter = ((SimpleConnectionPool)pool).waiters.poll();
                    return () -> new LeaseImpl<C>(this.slot, waiter.handler).emit();
                }
                ((Slot)this.slot).concurrency++;
            }
            return null;
        }
    }

    static class LeaseImpl<C>
    implements Lease<C> {
        private final Handler<AsyncResult<Lease<C>>> handler;
        private final Slot<C> slot;
        private final C connection;
        private boolean recycled;

        public LeaseImpl(Slot<C> slot, Handler<AsyncResult<Lease<C>>> handler) {
            this.handler = handler;
            this.slot = slot;
            this.connection = ((Slot)slot).connection;
        }

        @Override
        public C get() {
            return this.connection;
        }

        @Override
        public void recycle() {
            ((Slot)this.slot).pool.recycle(this);
        }

        void emit() {
            ((Slot)this.slot).context.emit(Future.succeededFuture(new LeaseImpl<C>(this.slot, this.handler)), this.handler);
        }
    }

    private static class Cancel<C>
    implements Executor.Action<SimpleConnectionPool<C>>,
    Runnable {
        private final PoolWaiter<C> waiter;
        private final Handler<AsyncResult<Boolean>> handler;
        private boolean cancelled;

        public Cancel(PoolWaiter<C> waiter, Handler<AsyncResult<Boolean>> handler) {
            this.waiter = waiter;
            this.handler = handler;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return () -> this.handler.handle(POOL_CLOSED);
            }
            if (((SimpleConnectionPool)pool).waiters.removeFirst(this.waiter)) {
                this.cancelled = true;
            } else if (!this.waiter.disposed) {
                this.waiter.disposed = true;
                this.cancelled = true;
            } else {
                this.cancelled = false;
            }
            return this;
        }

        @Override
        public void run() {
            this.handler.handle(Future.succeededFuture(this.cancelled));
        }
    }

    private static class Acquire<C>
    extends PoolWaiter<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        public Acquire(EventLoopContext context, PoolWaiter.Listener<C> listener, int capacity, Handler<AsyncResult<Lease<C>>> handler) {
            super(listener, context, capacity, handler);
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return () -> this.context.emit(POOL_CLOSED, this.handler);
            }
            Slot slot1 = (Slot)((SimpleConnectionPool)pool).selector.apply(this, ((SimpleConnectionPool)pool).list);
            if (slot1 != null) {
                slot1.concurrency--;
                return () -> new LeaseImpl(slot1, this.handler).emit();
            }
            if (((SimpleConnectionPool)pool).capacity < ((SimpleConnectionPool)pool).maxCapacity) {
                Slot<C> slot2;
                SimpleConnectionPool<C> simpleConnectionPool = pool;
                ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity + this.capacity;
                ((SimpleConnectionPool)pool).slots[((SimpleConnectionPool)pool).size++] = slot2 = new Slot<C>(pool, this.context, ((SimpleConnectionPool)pool).size, this.capacity);
                ((SimpleConnectionPool)pool).requests++;
                return () -> {
                    if (this.listener != null) {
                        this.listener.onConnect(this);
                    }
                    pool.connect(slot2, this);
                };
            }
            Slot slot3 = (Slot)((SimpleConnectionPool)pool).fallbackSelector.apply(this, ((SimpleConnectionPool)pool).list);
            if (slot3 != null) {
                slot3.concurrency--;
                return () -> new LeaseImpl(slot3, this.handler).emit();
            }
            if (((SimpleConnectionPool)pool).maxWaiters == -1 || ((SimpleConnectionPool)pool).waiters.size() + ((SimpleConnectionPool)pool).requests < ((SimpleConnectionPool)pool).maxWaiters) {
                ((SimpleConnectionPool)pool).waiters.addLast(this);
                return () -> {
                    if (this.listener != null) {
                        this.listener.onEnqueue(this);
                    }
                };
            }
            return () -> this.context.emit(Future.failedFuture(new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + ((SimpleConnectionPool)pool).maxWaiters)), this.handler);
        }
    }

    private static class Evict<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Predicate<C> predicate;
        private final Handler<AsyncResult<List<C>>> handler;

        public Evict(Predicate<C> predicate, Handler<AsyncResult<List<C>>> handler) {
            this.predicate = predicate;
            this.handler = handler;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return () -> this.handler.handle(POOL_CLOSED);
            }
            ArrayList<Object> res = new ArrayList<Object>();
            ArrayList<Slot> removed = new ArrayList<Slot>();
            for (int i = ((SimpleConnectionPool)pool).size - 1; i >= 0; --i) {
                Slot slot = ((SimpleConnectionPool)pool).slots[i];
                if (slot.connection == null || slot.concurrency != slot.maxConcurrency || !this.predicate.test(slot.connection)) continue;
                removed.add(slot);
                res.add(slot.connection);
            }
            for (Slot slot : removed) {
                ((SimpleConnectionPool)pool).remove(slot);
            }
            return () -> this.handler.handle(Future.succeededFuture(res));
        }
    }

    private static class SetConcurrency<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;
        private final long concurrency;

        SetConcurrency(Slot<C> slot, long concurrency) {
            this.slot = slot;
            this.concurrency = concurrency;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (((Slot)this.slot).connection != null) {
                if ((long)((Slot)this.slot).maxConcurrency < this.concurrency) {
                    long diff = this.concurrency - (long)((Slot)this.slot).maxConcurrency;
                    Slot<C> slot = this.slot;
                    ((Slot)slot).concurrency = (int)((long)((Slot)slot).concurrency + diff);
                    slot = this.slot;
                    ((Slot)slot).maxConcurrency = (int)((long)((Slot)slot).maxConcurrency + diff);
                    int m = Math.min(((Slot)this.slot).concurrency, ((SimpleConnectionPool)pool).waiters.size());
                    if (m > 0) {
                        LeaseImpl[] extra = new LeaseImpl[m];
                        for (int i = 0; i < m; ++i) {
                            extra[i] = new LeaseImpl<C>(this.slot, ((SimpleConnectionPool)pool).waiters.poll().handler);
                        }
                        Slot<C> slot2 = this.slot;
                        ((Slot)slot2).concurrency = ((Slot)slot2).concurrency - m;
                        return () -> {
                            for (LeaseImpl lease : extra) {
                                lease.emit();
                            }
                        };
                    }
                    return null;
                }
                throw new UnsupportedOperationException("Not yet implemented");
            }
            return null;
        }
    }

    private static class Remove<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        protected final Slot<C> removed;

        private Remove(Slot<C> removed) {
            this.removed = removed;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            if (pool.closed || pool.slots[((Slot)this.removed).index] != this.removed) {
                return null;
            }
            int w = ((Slot)this.removed).capacity;
            ((Slot)this.removed).concurrency = 0;
            ((Slot)this.removed).maxConcurrency = 0;
            ((Slot)this.removed).connection = null;
            ((Slot)this.removed).capacity = 0;
            PoolWaiter waiter = pool.waiters.poll();
            if (waiter != null) {
                Slot slot = new Slot(pool, waiter.context, ((Slot)this.removed).index, waiter.capacity);
                SimpleConnectionPool simpleConnectionPool = pool;
                simpleConnectionPool.capacity = simpleConnectionPool.capacity - w;
                simpleConnectionPool = pool;
                simpleConnectionPool.capacity = simpleConnectionPool.capacity + waiter.capacity;
                pool.slots[((Slot)this.removed).index] = slot;
                pool.requests++;
                return () -> {
                    if (waiter.listener != null) {
                        waiter.listener.onConnect(waiter);
                    }
                    pool.connect(slot, waiter);
                };
            }
            if (pool.size > 1) {
                Slot tmp = pool.slots[pool.size - 1];
                tmp.index = ((Slot)this.removed).index;
                pool.slots[((Slot)this.removed).index] = tmp;
                pool.slots[pool.size - 1] = null;
                pool.size--;
                SimpleConnectionPool simpleConnectionPool = pool;
                simpleConnectionPool.capacity = simpleConnectionPool.capacity - w;
                return null;
            }
            pool.slots[0] = null;
            pool.size--;
            SimpleConnectionPool simpleConnectionPool = pool;
            simpleConnectionPool.capacity = simpleConnectionPool.capacity - w;
            return null;
        }
    }

    private static class ConnectFailed<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> removed;
        private final Throwable cause;
        private PoolWaiter<C> waiter;

        public ConnectFailed(Slot<C> removed, Throwable cause, PoolWaiter<C> waiter) {
            this.removed = removed;
            this.cause = cause;
            this.waiter = waiter;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            ((SimpleConnectionPool)pool).requests--;
            if (this.waiter.disposed) {
                this.waiter = null;
            } else {
                this.waiter.disposed = true;
            }
            if (((SimpleConnectionPool)pool).closed) {
                return () -> this.waiter.handler.handle(POOL_CLOSED);
            }
            ((SimpleConnectionPool)pool).remove(this.removed);
            return () -> {
                if (this.waiter != null) {
                    ((Slot)this.removed).context.emit(Future.failedFuture(this.cause), this.waiter.handler);
                }
                ((Slot)this.removed).result.fail(this.cause);
            };
        }
    }

    private static class ConnectSuccess<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;
        private final ConnectResult<C> result;
        private PoolWaiter<C> waiter;

        private ConnectSuccess(Slot<C> slot, ConnectResult<C> result2, PoolWaiter<C> waiter) {
            this.slot = slot;
            this.result = result2;
            this.waiter = waiter;
        }

        @Override
        public Runnable execute(SimpleConnectionPool<C> pool) {
            LeaseImpl[] extra;
            int concurrency;
            int capacity = ((SimpleConnectionPool)pool).capacityFactors[(int)this.result.weight()];
            int initialCapacity = ((Slot)this.slot).capacity;
            ((Slot)this.slot).connection = this.result.connection();
            ((Slot)this.slot).maxConcurrency = (int)this.result.concurrency();
            ((Slot)this.slot).capacity = capacity;
            ((Slot)this.slot).concurrency = ((Slot)this.slot).maxConcurrency;
            ((SimpleConnectionPool)pool).requests--;
            SimpleConnectionPool<C> simpleConnectionPool = pool;
            ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity + (capacity - initialCapacity);
            if (((SimpleConnectionPool)pool).closed) {
                if (this.waiter.disposed) {
                    this.waiter = null;
                } else {
                    this.waiter.disposed = true;
                }
                return () -> {
                    if (this.waiter != null) {
                        ((Slot)this.slot).context.emit(POOL_CLOSED, this.waiter.handler);
                    }
                    ((Slot)this.slot).result.complete(((Slot)this.slot).connection);
                };
            }
            if (((Slot)this.slot).concurrency == 0) {
                if (!this.waiter.disposed) {
                    ((SimpleConnectionPool)pool).waiters.addFirst(this.waiter);
                }
                return null;
            }
            int c = 1;
            if (this.waiter.disposed) {
                this.waiter = null;
                concurrency = ((Slot)this.slot).concurrency;
            } else {
                this.waiter.disposed = true;
                concurrency = ((Slot)this.slot).concurrency - 1;
            }
            int m = Math.min(concurrency, ((SimpleConnectionPool)pool).waiters.size());
            if (m > 0) {
                c += m;
                extra = new LeaseImpl[m];
                for (int i = 0; i < m; ++i) {
                    extra[i] = new LeaseImpl<C>(this.slot, ((SimpleConnectionPool)pool).waiters.poll().handler);
                }
            } else {
                extra = null;
            }
            Slot<C> slot = this.slot;
            ((Slot)slot).concurrency = ((Slot)slot).concurrency - c;
            return () -> {
                if (this.waiter != null) {
                    new LeaseImpl<C>(this.slot, this.waiter.handler).emit();
                }
                if (extra != null) {
                    for (LeaseImpl lease : extra) {
                        lease.emit();
                    }
                }
                ((Slot)this.slot).result.complete(((Slot)this.slot).connection);
            };
        }
    }

    static class Slot<C>
    implements PoolConnector.Listener,
    PoolConnection<C> {
        private final SimpleConnectionPool<C> pool;
        private final EventLoopContext context;
        private final Promise<C> result;
        private PoolWaiter<C> initiator;
        private C connection;
        private int index;
        private int concurrency;
        private int maxConcurrency;
        private int capacity;

        public Slot(SimpleConnectionPool<C> pool, EventLoopContext context, int index, int capacity) {
            this.pool = pool;
            this.context = context;
            this.connection = null;
            this.concurrency = 0;
            this.index = index;
            this.capacity = capacity;
            this.result = context.promise();
        }

        @Override
        public void onRemove() {
            ((SimpleConnectionPool)this.pool).remove(this);
        }

        @Override
        public void onConcurrencyChange(long concurrency) {
            ((SimpleConnectionPool)this.pool).setConcurrency(this, concurrency);
        }

        @Override
        public Context context() {
            return this.context;
        }

        @Override
        public C get() {
            return this.connection;
        }

        @Override
        public int concurrency() {
            return this.concurrency;
        }

        @Override
        public int maxConcurrency() {
            return this.maxConcurrency;
        }
    }
}

