/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import java.util.Objects;

public class RoleBasedAuthorizationConverter {
    private static final String FIELD_TYPE = "type";
    private static final String TYPE_ROLE_BASED_AUTHORIZATION = "role";
    private static final String FIELD_ROLE = "role";
    private static final String FIELD_RESOURCE = "resource";

    public static JsonObject encode(RoleBasedAuthorization value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        JsonObject result2 = new JsonObject();
        result2.put(FIELD_TYPE, "role");
        result2.put("role", value.getRole());
        if (value.getResource() != null) {
            result2.put(FIELD_RESOURCE, value.getResource());
        }
        return result2;
    }

    public static RoleBasedAuthorization decode(JsonObject json) throws IllegalArgumentException {
        Objects.requireNonNull(json);
        if ("role".equals(json.getString(FIELD_TYPE))) {
            RoleBasedAuthorization result2 = RoleBasedAuthorization.create(json.getString("role"));
            if (json.getString(FIELD_RESOURCE) != null) {
                result2.setResource(json.getString(FIELD_RESOURCE));
            }
            return result2;
        }
        return null;
    }
}

