/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.kafka.admin;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.mutiny.core.Vertx;
import java.util.List;
import java.util.Map;
import java.util.Set;

@MutinyGen(value=io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient {
    public static final TypeArg<KafkaAdminClient> __TYPE_ARG = new TypeArg<KafkaAdminClient>(obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient)obj), KafkaAdminClient::getDelegate);
    private final io.vertx.kafka.admin.KafkaAdminClient delegate;

    public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
        this.delegate = delegate;
    }

    public KafkaAdminClient(Object delegate) {
        this.delegate = (io.vertx.kafka.admin.KafkaAdminClient)delegate;
    }

    KafkaAdminClient() {
        this.delegate = null;
    }

    public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaAdminClient that = (KafkaAdminClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static KafkaAdminClient create(Vertx vertx, Map<String, String> config) {
        KafkaAdminClient ret = KafkaAdminClient.newInstance(io.vertx.kafka.admin.KafkaAdminClient.create(vertx.getDelegate(), config));
        return ret;
    }

    public Uni<Set<String>> listTopics() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.listTopics((Handler<AsyncResult<Set<String>>>)completionHandler));
    }

    public Set<String> listTopicsAndAwait() {
        return this.listTopics().await().indefinitely();
    }

    public void listTopicsAndForget() {
        this.listTopics().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Map<String, TopicDescription>> describeTopics(List<String> topicNames) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.describeTopics(topicNames, (Handler<AsyncResult<Map<String, TopicDescription>>>)completionHandler));
    }

    public Map<String, TopicDescription> describeTopicsAndAwait(List<String> topicNames) {
        return this.describeTopics(topicNames).await().indefinitely();
    }

    public void describeTopicsAndForget(List<String> topicNames) {
        this.describeTopics(topicNames).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> createTopics(List<NewTopic> topics) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createTopics(topics, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void createTopicsAndAwait(List<NewTopic> topics) {
        return this.createTopics(topics).await().indefinitely();
    }

    public void createTopicsAndForget(List<NewTopic> topics) {
        this.createTopics(topics).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> deleteTopics(List<String> topicNames) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deleteTopics(topicNames, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void deleteTopicsAndAwait(List<String> topicNames) {
        return this.deleteTopics(topicNames).await().indefinitely();
    }

    public void deleteTopicsAndForget(List<String> topicNames) {
        this.deleteTopics(topicNames).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> createPartitions(Map<String, NewPartitions> partitions) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createPartitions(partitions, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void createPartitionsAndAwait(Map<String, NewPartitions> partitions) {
        return this.createPartitions(partitions).await().indefinitely();
    }

    public void createPartitionsAndForget(Map<String, NewPartitions> partitions) {
        this.createPartitions(partitions).subscribe().with(UniHelper.NOOP);
    }

    public Uni<List<ConsumerGroupListing>> listConsumerGroups() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.listConsumerGroups((Handler<AsyncResult<List<ConsumerGroupListing>>>)completionHandler));
    }

    public List<ConsumerGroupListing> listConsumerGroupsAndAwait() {
        return this.listConsumerGroups().await().indefinitely();
    }

    public void listConsumerGroupsAndForget() {
        this.listConsumerGroups().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.describeConsumerGroups(groupIds, (Handler<AsyncResult<Map<String, ConsumerGroupDescription>>>)completionHandler));
    }

    public Map<String, ConsumerGroupDescription> describeConsumerGroupsAndAwait(List<String> groupIds) {
        return this.describeConsumerGroups(groupIds).await().indefinitely();
    }

    public void describeConsumerGroupsAndForget(List<String> groupIds) {
        this.describeConsumerGroups(groupIds).subscribe().with(UniHelper.NOOP);
    }

    public Uni<ClusterDescription> describeCluster() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.describeCluster((Handler<AsyncResult<ClusterDescription>>)completionHandler));
    }

    public ClusterDescription describeClusterAndAwait() {
        return this.describeCluster().await().indefinitely();
    }

    public void describeClusterAndForget() {
        this.describeCluster().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> deleteConsumerGroups(List<String> groupIds) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deleteConsumerGroups(groupIds, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void deleteConsumerGroupsAndAwait(List<String> groupIds) {
        return this.deleteConsumerGroups(groupIds).await().indefinitely();
    }

    public void deleteConsumerGroupsAndForget(List<String> groupIds) {
        this.deleteConsumerGroups(groupIds).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deleteConsumerGroupOffsets(groupId, partitions, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void deleteConsumerGroupOffsetsAndAwait(String groupId, Set<TopicPartition> partitions) {
        return this.deleteConsumerGroupOffsets(groupId, partitions).await().indefinitely();
    }

    public void deleteConsumerGroupOffsetsAndForget(String groupId, Set<TopicPartition> partitions) {
        this.deleteConsumerGroupOffsets(groupId, partitions).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> close(long timeout) {
        return AsyncResultUni.toUni(handler -> this.delegate.close(timeout, (Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait(long timeout) {
        return this.close(timeout).await().indefinitely();
    }

    public void closeAndForget(long timeout) {
        this.close(timeout).subscribe().with(UniHelper.NOOP);
    }

    public static KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
        return arg != null ? new KafkaAdminClient(arg) : null;
    }
}

