/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;

@BuiltBy(value=RemoteCacheConfigurationBuilder.class)
public class RemoteCacheConfiguration {
    public static final AttributeDefinition<String> CONFIGURATION = AttributeDefinition.builder("configuration", null, String.class).build();
    public static final AttributeDefinition<Boolean> FORCE_RETURN_VALUES = AttributeDefinition.builder("force-return-values", false, Boolean.class).build();
    public static final AttributeDefinition<String> NAME = AttributeDefinition.builder("name", null, String.class).build();
    public static final AttributeDefinition<NearCacheMode> NEAR_CACHE_MODE = AttributeDefinition.builder("near-cache-mode", NearCacheMode.DISABLED).build();
    public static final AttributeDefinition<Integer> NEAR_CACHE_MAX_ENTRIES = AttributeDefinition.builder("near-cache-max-entries", -1).build();
    public static final AttributeDefinition<Boolean> NEAR_CACHE_BLOOM_FILTER = AttributeDefinition.builder("near-cache-bloom-filter", false).build();
    public static final AttributeDefinition<String> TEMPLATE_NAME = AttributeDefinition.builder("template-name", null, String.class).build();
    public static final AttributeDefinition<TransactionMode> TRANSACTION_MODE = AttributeDefinition.builder("transaction-mode", TransactionMode.NONE).build();
    public static final AttributeDefinition<TransactionManagerLookup> TRANSACTION_MANAGER = AttributeDefinition.builder("transaction-manager", GenericTransactionManagerLookup.getInstance(), TransactionManagerLookup.class).build();
    public static final AttributeDefinition<Marshaller> MARSHALLER = AttributeDefinition.builder("marshaller", null, Marshaller.class).build();
    public static final AttributeDefinition<Class> MARSHALLER_CLASS = AttributeDefinition.builder("marshallerClass", null, Class.class).build();
    private final Attribute<String> configuration;
    private final Attribute<Boolean> forceReturnValues;
    private final Attribute<Marshaller> marshaller;
    private final Attribute<Class> marshallerClass;
    private final Attribute<String> name;
    private final Attribute<NearCacheMode> nearCacheMode;
    private final Attribute<Integer> nearCacheMaxEntries;
    private final Attribute<Boolean> nearCacheBloomFilter;
    private final Attribute<String> templateName;
    private final Attribute<TransactionMode> transactionMode;
    private final Attribute<TransactionManagerLookup> transactionManager;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RemoteCacheConfiguration.class, CONFIGURATION, FORCE_RETURN_VALUES, NAME, MARSHALLER, MARSHALLER_CLASS, NEAR_CACHE_MODE, NEAR_CACHE_MAX_ENTRIES, NEAR_CACHE_BLOOM_FILTER, TEMPLATE_NAME, TRANSACTION_MODE, TRANSACTION_MANAGER);
    }

    RemoteCacheConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.configuration = attributes.attribute(CONFIGURATION);
        this.forceReturnValues = attributes.attribute(FORCE_RETURN_VALUES);
        this.name = attributes.attribute(NAME);
        this.marshaller = attributes.attribute(MARSHALLER);
        this.marshallerClass = attributes.attribute(MARSHALLER_CLASS);
        this.nearCacheMode = attributes.attribute(NEAR_CACHE_MODE);
        this.nearCacheMaxEntries = attributes.attribute(NEAR_CACHE_MAX_ENTRIES);
        this.nearCacheBloomFilter = attributes.attribute(NEAR_CACHE_BLOOM_FILTER);
        this.templateName = attributes.attribute(TEMPLATE_NAME);
        this.transactionMode = attributes.attribute(TRANSACTION_MODE);
        this.transactionManager = attributes.attribute(TRANSACTION_MANAGER);
    }

    public String configuration() {
        return this.configuration.get();
    }

    public boolean forceReturnValues() {
        return this.forceReturnValues.get();
    }

    public String name() {
        return this.name.get();
    }

    public Marshaller marshaller() {
        return this.marshaller.get();
    }

    public Class<? extends Marshaller> marshallerClass() {
        return this.marshallerClass.get();
    }

    public NearCacheMode nearCacheMode() {
        return this.nearCacheMode.get();
    }

    public int nearCacheMaxEntries() {
        return this.nearCacheMaxEntries.get();
    }

    public boolean nearCacheBloomFilter() {
        return this.nearCacheBloomFilter.get();
    }

    public String templateName() {
        return this.templateName.get();
    }

    public TransactionMode transactionMode() {
        return this.transactionMode.get();
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return this.transactionManager.get();
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "RemoteCacheConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteCacheConfiguration other = (RemoteCacheConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result2;
    }
}

