/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.operations.StatsAffectingRetryingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;

public class BulkGetKeysOperation<K>
extends StatsAffectingRetryingOperation<Set<K>> {
    private final int scope;
    private final Set<K> result = new HashSet<K>();

    public BulkGetKeysOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, int scope, DataFormat dataFormat, ClientStatistics clientStatistics) {
        super((short)29, (short)30, codec, channelFactory, cacheName, topologyId, flags, cfg, dataFormat, clientStatistics);
        this.scope = scope;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(this.scope));
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeVInt(buf, this.scope);
        channel.writeAndFlush(buf);
    }

    @Override
    protected void reset() {
        super.reset();
        this.result.clear();
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        while (buf.readUnsignedByte() == 1) {
            this.result.add(MarshallerUtil.bytes2obj(this.channelFactory.getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat.isObjectStorage(), this.cfg.getClassAllowList()));
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

