/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.impl.AbstractClientEvent;
import org.infinispan.client.hotrod.event.impl.CreatedEventImpl;
import org.infinispan.client.hotrod.event.impl.CustomEventImpl;
import org.infinispan.client.hotrod.event.impl.ModifiedEventImpl;
import org.infinispan.client.hotrod.event.impl.RemovedEventImpl;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecUtils;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.counter.api.CounterState;

public class Codec20
implements Codec,
HotRodConstants {
    static final Log log = LogFactory.getLog(Codec.class, Log.class);

    @Override
    public void writeClientListenerInterests(ByteBuf buf, Set<Class<? extends Annotation>> classes) {
    }

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)20);
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        buf.writeByte((short)(clientListener.includeCurrentState() ? 1 : 0));
        this.writeNamedFactory(buf, clientListener.filterFactoryName(), filterFactoryParams);
        this.writeNamedFactory(buf, clientListener.converterFactoryName(), converterFactoryParams);
    }

    @Override
    public void writeExpirationParams(ByteBuf buf, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        if (!CodecUtils.isGreaterThan4bytes(lifespan)) {
            Log.HOTROD.warn("Lifespan value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        if (!CodecUtils.isGreaterThan4bytes(maxIdle)) {
            Log.HOTROD.warn("MaxIdle value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        ByteBufUtil.writeVInt(buf, lifespanSeconds);
        ByteBufUtil.writeVInt(buf, maxIdleSeconds);
    }

    @Override
    public void writeBloomFilter(ByteBuf buf, int bloomFilterBits) {
        if (bloomFilterBits > 0) {
            throw new UnsupportedOperationException("Bloom Filter optimization is not available for versions before 3.1");
        }
    }

    @Override
    public int estimateExpirationSize(long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        return ByteBufUtil.estimateVIntSize(lifespanSeconds) + ByteBufUtil.estimateVIntSize(maxIdleSeconds);
    }

    private void writeNamedFactory(ByteBuf buf, String factoryName, byte[][] params) {
        ByteBufUtil.writeString(buf, factoryName);
        if (!factoryName.isEmpty()) {
            if (params != null) {
                buf.writeByte((short)params.length);
                for (byte[] param2 : params) {
                    ByteBufUtil.writeArray(buf, param2);
                }
            } else {
                buf.writeByte(0);
            }
        }
    }

    protected HeaderParams writeHeader(ByteBuf buf, HeaderParams params, byte version) {
        buf.writeByte(160);
        ByteBufUtil.writeVLong(buf, params.messageId);
        buf.writeByte(version);
        buf.writeByte(params.opCode);
        ByteBufUtil.writeArray(buf, params.cacheName);
        int joinedFlags = params.flags;
        ByteBufUtil.writeVInt(buf, joinedFlags);
        buf.writeByte(params.clientIntel);
        int topologyId = params.topologyId.get();
        ByteBufUtil.writeVInt(buf, topologyId);
        if (log.isTraceEnabled()) {
            this.getLog().tracef("[%s] Wrote header for messageId=%d. Operation code: %#04x(%s). Flags: %#x. Topology id: %s", new String(params.cacheName), params.messageId, params.opCode, HotRodConstants.Names.of(params.opCode), joinedFlags, topologyId);
        }
        return params;
    }

    @Override
    public int estimateHeaderSize(HeaderParams params) {
        return 1 + ByteBufUtil.estimateVLongSize(params.messageId) + 1 + 1 + ByteBufUtil.estimateArraySize(params.cacheName) + ByteBufUtil.estimateVIntSize(params.flags) + 1 + 1 + ByteBufUtil.estimateVIntSize(params.topologyId.get());
    }

    @Override
    public long readMessageId(ByteBuf buf) {
        short magic = buf.readUnsignedByte();
        if (magic != 161) {
            Log localLog = this.getLog();
            if (log.isTraceEnabled()) {
                localLog.tracef("Socket dump: %s", (Object)ByteBufUtil.limitedHexDump(buf));
            }
            throw Log.HOTROD.invalidMagicNumber((short)161, magic);
        }
        return ByteBufUtil.readVLong(buf);
    }

    @Override
    public short readOpCode(ByteBuf buf) {
        return buf.readUnsignedByte();
    }

    @Override
    public short readHeader(ByteBuf buf, double receivedOpCode, HeaderParams params, ChannelFactory channelFactory, SocketAddress serverAddress) {
        short status = buf.readUnsignedByte();
        this.readNewTopologyIfPresent(buf, params, channelFactory);
        if (receivedOpCode != (double)params.opRespCode) {
            if (receivedOpCode == 80.0) {
                this.checkForErrorsInResponseStatus(buf, params, status, serverAddress);
            }
            throw Log.HOTROD.invalidResponse(new String(params.cacheName), params.opRespCode, receivedOpCode);
        }
        return status;
    }

    private static CounterState decodeOldState(short encoded) {
        switch (encoded & 3) {
            case 0: {
                return CounterState.VALID;
            }
            case 1: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 2: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    private static CounterState decodeNewState(short encoded) {
        switch (encoded & 0xC) {
            case 0: {
                return CounterState.VALID;
            }
            case 4: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 8: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public HotRodCounterEvent readCounterEvent(ByteBuf buf) {
        short status = buf.readByte();
        assert (status == 0);
        short topology = buf.readByte();
        assert (topology == 0);
        String counterName = ByteBufUtil.readString(buf);
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short encodedCounterState = buf.readByte();
        long oldValue = buf.readLong();
        long newValue = buf.readLong();
        return new HotRodCounterEvent(listenerId, counterName, oldValue, Codec20.decodeOldState(encodedCounterState), newValue, Codec20.decodeNewState(encodedCounterState));
    }

    @Override
    public <K> CloseableIterator<K> keyIterator(RemoteCache<K, ?> remoteCache, OperationsFactory operationsFactory, IntSet segments, int batchSize) {
        if (segments != null) {
            throw new UnsupportedOperationException("This version doesn't support iterating upon keys by segment!");
        }
        BulkGetKeysOperation op = operationsFactory.newBulkGetKeysOperation(0, remoteCache.getDataFormat());
        Set keys = (Set)Util.await(op.execute());
        return Closeables.iterator(keys.iterator());
    }

    @Override
    public boolean isObjectStorageHinted(PingResponse pingResponse) {
        return false;
    }

    @Override
    public AbstractClientEvent readCacheEvent(ByteBuf buf, Function<byte[], DataFormat> listenerDataFormat, short eventTypeId, ClassAllowList allowList, SocketAddress serverAddress) {
        ClientEvent.Type eventType;
        short status = buf.readUnsignedByte();
        buf.readUnsignedByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(buf, null, status, serverAddress);
            }
            default: {
                throw Log.HOTROD.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = ByteBufUtil.readArray(buf);
        short isCustom = buf.readUnsignedByte();
        boolean isRetried = buf.readUnsignedByte() == 1;
        DataFormat dataFormat = listenerDataFormat.apply(listenerId);
        if (isCustom == 1) {
            Object eventData = dataFormat.valueToObj(ByteBufUtil.readArray(buf), allowList);
            return this.createCustomEvent(listenerId, eventData, eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                long createdDataVersion = buf.readLong();
                return this.createCreatedEvent(listenerId, dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList), createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                long modifiedDataVersion = buf.readLong();
                return this.createModifiedEvent(listenerId, dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList), modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.createRemovedEvent(listenerId, dataFormat.keyToObj(ByteBufUtil.readArray(buf), allowList), isRetried);
            }
        }
        throw Log.HOTROD.unknownEvent(eventTypeId);
    }

    @Override
    public Object returnPossiblePrevValue(ByteBuf buf, short status, DataFormat dataFormat, int flags, ClassAllowList allowList, Marshaller marshaller) {
        if (HotRodConstants.hasPrevious(status)) {
            return dataFormat.valueToObj(ByteBufUtil.readArray(buf), allowList);
        }
        return null;
    }

    protected AbstractClientEvent createRemovedEvent(byte[] listenerId, Object key, boolean isRetried) {
        return new RemovedEventImpl<Object>(listenerId, key, isRetried);
    }

    protected AbstractClientEvent createModifiedEvent(byte[] listenerId, Object key, long dataVersion, boolean isRetried) {
        return new ModifiedEventImpl<Object>(listenerId, key, dataVersion, isRetried);
    }

    protected AbstractClientEvent createCreatedEvent(byte[] listenerId, Object key, long dataVersion, boolean isRetried) {
        return new CreatedEventImpl<Object>(listenerId, key, dataVersion, isRetried);
    }

    protected AbstractClientEvent createCustomEvent(byte[] listenerId, Object eventData, ClientEvent.Type eventType, boolean isRetried) {
        return new CustomEventImpl<Object>(listenerId, eventData, isRetried, eventType);
    }

    @Override
    public Log getLog() {
        return log;
    }

    protected void checkForErrorsInResponseStatus(ByteBuf buf, HeaderParams params, short status, SocketAddress serverAddress) {
        Log localLog = this.getLog();
        if (log.isTraceEnabled()) {
            localLog.tracef("[%s] Received operation status: %#x", (Object)new String(params.cacheName), (Object)status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (status == 134 && log.isTraceEnabled()) {
                        localLog.tracef("Server-side timeout performing operation: %s", (Object)msgFromServer);
                    } else {
                        Log.HOTROD.errorFromServer(msgFromServer);
                    }
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
                case 136: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    throw new RemoteIllegalLifecycleStateException(msgFromServer, params.messageId, status, serverAddress);
                }
                case 135: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (log.isTraceEnabled()) {
                        localLog.tracef("[%s] A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", (Object)new String(params.cacheName), (Object)params.messageId, (Object)msgFromServer);
                    }
                    throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                default: 
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        short topologyChangeByte = buf.readUnsignedByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(buf, params, channelFactory);
        }
    }

    protected void readNewTopologyAndHash(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        SocketAddress[][] segmentOwners;
        short hashFunctionVersion;
        Log localLog = this.getLog();
        int newTopologyId = ByteBufUtil.readVInt(buf);
        Object[] addresses = this.readTopology(buf);
        if (params.clientIntel == ClientIntelligence.HASH_DISTRIBUTION_AWARE.getValue()) {
            hashFunctionVersion = buf.readUnsignedByte();
            int numSegments = ByteBufUtil.readVInt(buf);
            segmentOwners = new SocketAddress[numSegments][];
            if (hashFunctionVersion > 0) {
                for (int i = 0; i < numSegments; ++i) {
                    int numOwners = buf.readUnsignedByte();
                    segmentOwners[i] = new SocketAddress[numOwners];
                    for (int j = 0; j < numOwners; ++j) {
                        int memberIndex = ByteBufUtil.readVInt(buf);
                        segmentOwners[i][j] = addresses[memberIndex];
                    }
                }
            }
        } else {
            hashFunctionVersion = -1;
            segmentOwners = null;
        }
        int currentTopology = channelFactory.getTopologyId(params.cacheName);
        int topologyAge = channelFactory.getTopologyAge();
        if (params.topologyAge < topologyAge || params.topologyAge == topologyAge && currentTopology != newTopologyId) {
            params.topologyId.set(newTopologyId);
            List<InetSocketAddress> addressList = Arrays.asList(addresses);
            if (Log.HOTROD.isInfoEnabled()) {
                Log.HOTROD.newTopology(newTopologyId, topologyAge, addresses.length, new HashSet<SocketAddress>(addressList));
            }
            channelFactory.updateServers(addressList, params.cacheName, false);
            if (hashFunctionVersion >= 0) {
                if (log.isTraceEnabled()) {
                    String cacheNameString = new String(params.cacheName);
                    if (hashFunctionVersion == 0) {
                        localLog.tracef("[%s] Not using a consistent hash function (hash function version == 0).", (Object)cacheNameString);
                    } else {
                        localLog.tracef("[%s] Updating client hash function with %s number of segments", (Object)cacheNameString, (Object)segmentOwners.length);
                    }
                }
                channelFactory.updateHashFunction(segmentOwners, segmentOwners.length, hashFunctionVersion, params.cacheName, params.topologyId);
            }
        } else if (log.isTraceEnabled()) {
            localLog.tracef("[%s] Outdated topology received (topology id = %s, topology age = %s), so ignoring it: %s", new String(params.cacheName), newTopologyId, topologyAge, Arrays.toString(addresses));
        }
    }

    private InetSocketAddress[] readTopology(ByteBuf buf) {
        int clusterSize = ByteBufUtil.readVInt(buf);
        InetSocketAddress[] addresses = new InetSocketAddress[clusterSize];
        for (int i = 0; i < clusterSize; ++i) {
            String host = ByteBufUtil.readString(buf);
            int port = buf.readUnsignedShort();
            addresses[i] = InetSocketAddress.createUnresolved(host, port);
        }
        return addresses;
    }
}

