/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.io.AbstractConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;

public class YamlConfigurationReader
extends AbstractConfigurationReader {
    private final Deque<Parsed> state = new ArrayDeque<Parsed>();
    private final List<String> attributeNames = new ArrayList<String>();
    private final List<String> attributeValues = new ArrayList<String>();
    private final List<String> attributeNamespaces = new ArrayList<String>();
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final BufferedReader reader;
    private Parsed next;
    private ConfigurationReader.ElementType type = ConfigurationReader.ElementType.START_DOCUMENT;
    private int line = 0;
    private Node lines;

    public YamlConfigurationReader(Reader reader, ConfigurationResourceResolver resolver, Properties properties, PropertyReplacer replacer, NamingStrategy namingStrategy) {
        super(resolver, properties, replacer, namingStrategy);
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.namespaces.put("", "");
        this.loadTree();
    }

    private void loadTree() {
        Node current = null;
        do {
            try {
                do {
                    this.next = this.parseLine(this.reader.readLine());
                } while (this.next != null && this.next.name == null && this.next.value == null);
            }
            catch (IOException e) {
                throw new ConfigurationReaderException(e, Location.of(this.line, 1));
            }
            if (this.next == null) {
                return;
            }
            if (this.lines == null) {
                current = this.lines = new Node(this.next);
                continue;
            }
            if (this.next.indent == current.line.indent) {
                current = current.addSibling(new Node(this.next));
                continue;
            }
            if (this.next.indent > current.line.indent) {
                current = current.addChild(new Node(this.next));
                continue;
            }
            while (this.next.indent <= current.line.indent) {
                current = current.parent;
            }
            current = current.addChild(new Node(this.next));
        } while (this.next != null);
    }

    private static boolean isAttribute(Parsed p) {
        return p.name != null && p.value != null;
    }

    Parsed parseLine(String s) {
        int length;
        if (s == null) {
            return null;
        }
        Parsed parsed = new Parsed(++this.line);
        for (length = s.length(); length > 0 && s.charAt(length - 1) == ' '; --length) {
        }
        int state = 0;
        int start = -1;
        block12: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    if (state != 0) continue block12;
                    ++parsed.indent;
                    continue block12;
                }
                case '\t': {
                    if (state != 0) continue block12;
                    parsed.indent += 2;
                    continue block12;
                }
                case '#': {
                    if (state == 3) {
                        parsed.value = s.substring(start, i - 1).trim();
                        return parsed;
                    }
                    if (state == 1) {
                        throw new ConfigurationReaderException("Invalid comment", Location.of(this.line, i));
                    }
                    return parsed;
                }
                case ':': {
                    if (i + 1 != length && s.charAt(i + 1) != ' ' || state != 1) continue block12;
                    this.parseKey(parsed, s.substring(start, i));
                    state = 2;
                    continue block12;
                }
                case '~': {
                    if (state == 2 || i + 1 == length) {
                        parsed.value = null;
                        return parsed;
                    }
                }
                case '\\': {
                    if (i + 1 == length) {
                        throw new ConfigurationReaderException("Incomplete escape sequence", Location.of(this.line, i));
                    }
                    ++i;
                    continue block12;
                }
                case '%': {
                    if (i != 0) continue block12;
                    String[] parts = s.split(" ");
                    if (parts.length == 3 && parts[0].equals("%TAG") && parts[1].startsWith("!") && parts[1].endsWith("!")) {
                        if ("!".equals(parts[1])) {
                            this.namespaces.put("", parts[2]);
                        } else {
                            this.namespaces.put(parts[1].substring(1, parts[1].length() - 1), parts[2]);
                        }
                        return parsed;
                    }
                    if (parts.length == 2 && parts[0].equals("%YAML")) {
                        return parsed;
                    }
                    Log.CONFIG.warn("Unknown directive " + s + " at " + Location.of(this.line, i));
                    continue block12;
                }
                case '-': {
                    if (i == 0) {
                        if (!"---".equals(s)) continue block12;
                        return parsed;
                    }
                    if (s.charAt(i + 1) != ' ') continue block12;
                    parsed.list = true;
                    ++i;
                    if (state != 0 || s.charAt(length - 1) == ':') continue block12;
                    state = 2;
                    continue block12;
                }
                case '\"': 
                case '\'': {
                    if (state == 0 || state == 2) {
                        int endQuote = s.indexOf(c, i + 1);
                        if (endQuote < 0) {
                            throw new ConfigurationReaderException("Missing closing quote", Location.of(this.line, i));
                        }
                        String v = s.substring(i + 1, endQuote).trim();
                        if (state == 0) {
                            this.parseKey(parsed, v);
                            state = 2;
                        } else {
                            parsed.value = v;
                            state = 4;
                        }
                        i = endQuote + 1;
                        continue block12;
                    }
                }
                default: {
                    if (state == 0) {
                        state = 1;
                        start = i;
                        continue block12;
                    }
                    if (state != 2) continue block12;
                    state = 3;
                    start = i;
                }
            }
        }
        if (state == 1) {
            throw new ConfigurationReaderException("Incomplete line", Location.of(this.line, 1));
        }
        if (state == 3) {
            parsed.value = s.substring(start).trim();
        }
        return parsed;
    }

    private void parseKey(Parsed p, String s) {
        int colon2 = s.lastIndexOf(58);
        p.name = this.namingStrategy.convert(colon2 < 0 ? s : s.substring(colon2 + 1));
        String string = p.nsPrefix = colon2 < 0 ? "" : s.substring(0, colon2);
        if (!p.nsPrefix.isEmpty()) {
            this.namespaces.putIfAbsent(p.nsPrefix, this.namingStrategy.convert(p.nsPrefix));
        }
    }

    private void readNext() {
        do {
            if (this.lines != null) {
                this.next = this.lines.line;
                this.lines = this.lines.next();
                continue;
            }
            this.next = null;
        } while (this.next != null && this.next.name == null && this.next.value == null);
    }

    @Override
    public ConfigurationReader.ElementType nextElement() {
        if (this.next == null) {
            this.readNext();
        }
        this.resetAttributes();
        if (this.next == null) {
            if (this.state.isEmpty()) {
                this.type = ConfigurationReader.ElementType.END_DOCUMENT;
            } else {
                if (this.type == ConfigurationReader.ElementType.END_ELEMENT) {
                    this.state.pop();
                }
                this.type = this.state.isEmpty() ? ConfigurationReader.ElementType.END_DOCUMENT : ConfigurationReader.ElementType.END_ELEMENT;
            }
        } else {
            if (!this.state.isEmpty()) {
                if (this.next.indent < this.state.peek().indent) {
                    if (this.type == ConfigurationReader.ElementType.END_ELEMENT) {
                        this.state.pop();
                    }
                    this.type = ConfigurationReader.ElementType.END_ELEMENT;
                    return this.type;
                }
                if (this.next.indent == this.state.peek().indent) {
                    if (this.type != ConfigurationReader.ElementType.END_ELEMENT) {
                        this.type = ConfigurationReader.ElementType.END_ELEMENT;
                        return this.type;
                    }
                    this.state.pop();
                } else if (this.next.list && this.state.peek().list) {
                    if (this.type != ConfigurationReader.ElementType.END_ELEMENT) {
                        this.type = ConfigurationReader.ElementType.END_ELEMENT;
                        return this.type;
                    }
                    this.state.peek().value = this.next.value;
                    this.readNext();
                    this.type = ConfigurationReader.ElementType.START_ELEMENT;
                    return this.type;
                }
            }
            this.state.push(this.next);
            int currentIndent = this.next.indent;
            this.readNext();
            if (this.next != null && this.next.name == null && this.next.list) {
                Parsed current = this.state.peek();
                current.list = true;
                current.value = this.next.value;
                this.readNext();
            } else {
                while (this.next != null && this.next.indent > currentIndent && this.next.name != null && this.next.value != null) {
                    this.attributeNames.add(this.next.name);
                    this.attributeNamespaces.add(this.next.nsPrefix);
                    this.attributeValues.add(this.replaceProperties(this.next.value));
                    this.readNext();
                }
            }
            this.type = ConfigurationReader.ElementType.START_ELEMENT;
        }
        return this.type;
    }

    private void resetAttributes() {
        this.attributeNames.clear();
        this.attributeValues.clear();
        this.attributeNamespaces.clear();
    }

    @Override
    public Location getLocation() {
        return Location.of(this.line, 1);
    }

    @Override
    public String getAttributeName(int index, NamingStrategy strategy) {
        return strategy.convert(this.attributeNames.get(index));
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.namespaces.get(this.attributeNamespaces.get(index));
    }

    @Override
    public String getAttributeValue(String name) {
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            if (!name.equals(this.attributeNames.get(i))) continue;
            return this.attributeValues.get(i);
        }
        return null;
    }

    @Override
    public String getAttributeValue(int index) {
        return this.attributeValues.get(index);
    }

    @Override
    public String getElementText() {
        return this.replaceProperties(this.state.peek().value);
    }

    @Override
    public String getLocalName(NamingStrategy strategy) {
        return strategy.convert(this.state.peek().name);
    }

    @Override
    public String getNamespace() {
        return this.namespaces.get(this.state.peek().nsPrefix);
    }

    @Override
    public boolean hasNext() {
        if (!this.state.isEmpty()) {
            return true;
        }
        if (this.next == null) {
            this.readNext();
        }
        return this.next != null;
    }

    @Override
    public int getAttributeCount() {
        return this.attributeNames.size();
    }

    @Override
    public void require(ConfigurationReader.ElementType type, String namespace, String name) {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getLocalName())) {
            throw new ConfigurationReaderException("Expected event " + (Object)((Object)type) + (name != null ? " with name '" + name + "'" : "") + (namespace != null && name != null ? " and" : "") + (namespace != null ? " with namespace '" + namespace + "'" : "") + " but got" + (type != this.type ? " " + (Object)((Object)this.type) : "") + (name != null && this.getLocalName() != null && !name.equals(this.getLocalName()) ? " name '" + this.getLocalName() + "'" : "") + (namespace != null && name != null && this.getLocalName() != null && !name.equals(this.getLocalName()) && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " and" : "") + (namespace != null && this.getNamespace() != null && !namespace.equals(this.getNamespace()) ? " namespace '" + this.getNamespace() + "'" : ""), Location.of(this.line, 1));
        }
    }

    @Override
    public void close() throws Exception {
        Util.close((AutoCloseable)this.reader);
    }

    public static class Parsed {
        final int line;
        int indent;
        boolean list;
        String name;
        String nsPrefix;
        String value;

        public Parsed(int line) {
            this.line = line;
        }

        public String toString() {
            return "Parsed{line=" + this.line + ", indent=" + this.indent + ", list=" + this.list + ", name='" + this.name + '\'' + ", nsPrefix='" + this.nsPrefix + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    private static class Node {
        final Parsed line;
        Deque<Node> children;
        Node parent;

        Node(Parsed line) {
            this.line = line;
        }

        Node addChild(Node child) {
            if (this.children == null) {
                this.children = new ArrayDeque<Node>();
            }
            if (YamlConfigurationReader.isAttribute(child.line)) {
                this.children.addFirst(child);
            } else {
                this.children.addLast(child);
            }
            child.parent = this;
            return child;
        }

        Node addSibling(Node sibling) {
            this.parent.addChild(sibling);
            return sibling;
        }

        Node next() {
            if (this.children != null && !this.children.isEmpty()) {
                return this.children.removeFirst();
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.next();
        }

        public String toString() {
            return this.line.toString();
        }
    }
}

