/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ResteasyHttpHeaders
implements HttpHeaders {
    private MultivaluedMap<String, String> requestHeaders;
    private MultivaluedMap<String, String> unmodifiableRequestHeaders;
    private Map<String, Cookie> cookies;
    private String cachedMediaTypeString;
    private MediaType cachedMediaType;

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders) {
        this(requestHeaders, new HashMap<String, Cookie>());
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, boolean eagerlyInitializeEntrySet) {
        this(requestHeaders, new HashMap<String, Cookie>(), eagerlyInitializeEntrySet);
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies) {
        this(requestHeaders, cookies, true);
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies, boolean eagerlyInitializeEntrySet) {
        this.requestHeaders = requestHeaders;
        this.unmodifiableRequestHeaders = new UnmodifiableMultivaluedMap<String, String>(requestHeaders, eagerlyInitializeEntrySet);
        this.cookies = cookies == null ? new HashMap() : cookies;
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.unmodifiableRequestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    public void testParsing() {
        this.getAcceptableMediaTypes();
        this.getMediaType();
        this.getLanguage();
        this.getAcceptableLanguages();
    }

    @Override
    public List<String> getRequestHeader(String name) {
        List vals = (List)this.unmodifiableRequestHeaders.get(name);
        return vals == null ? Collections.emptyList() : vals;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        this.mergeCookies();
        return Collections.unmodifiableMap(this.cookies);
    }

    public Map<String, Cookie> getMutableCookies() {
        this.mergeCookies();
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public Date getDate() {
        String date = this.requestHeaders.getFirst("Date");
        if (date == null) {
            return null;
        }
        return DateUtil.parseDate(date);
    }

    @Override
    public String getHeaderString(String name) {
        List vals = (List)this.requestHeaders.get(name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(val);
        }
        return builder.toString();
    }

    @Override
    public Locale getLanguage() {
        String obj = this.requestHeaders.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        return new Locale(obj);
    }

    @Override
    public int getLength() {
        String obj = this.requestHeaders.getFirst("Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    @Override
    public MediaType getMediaType() {
        String obj = this.requestHeaders.getFirst("Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj == this.cachedMediaTypeString) {
            return this.cachedMediaType;
        }
        this.cachedMediaTypeString = obj;
        this.cachedMediaType = MediaType.valueOf(obj);
        return this.cachedMediaType;
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        List vals = (List)this.requestHeaders.get("Accept");
        if (vals == null || vals.isEmpty()) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (String v : vals) {
            StringTokenizer tokenizer = new StringTokenizer(v, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                list.add(MediaType.valueOf(item));
            }
        }
        MediaTypeHelper.sortByWeight(list);
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        List vals = (List)this.requestHeaders.get("Accept-Language");
        if (vals == null || vals.isEmpty()) {
            return Collections.singletonList(Locale.forLanguageTag("*"));
        }
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        for (String v : vals) {
            StringTokenizer tokenizer = new StringTokenizer(v, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                languages.add(WeightedLanguage.parse(item));
            }
        }
        Collections.sort(languages);
        ArrayList<Locale> list = new ArrayList<Locale>(languages.size());
        for (WeightedLanguage language2 : languages) {
            list.add(language2.getLocale());
        }
        return Collections.unmodifiableList(list);
    }

    private void mergeCookies() {
        List cookieHeader = (List)this.requestHeaders.get("Cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            for (String s : cookieHeader) {
                List<Cookie> list = CookieParser.parseCookies(s);
                for (Cookie cookie : list) {
                    this.cookies.put(cookie.getName(), cookie);
                }
            }
        }
    }
}

