/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.List;
import org.kie.pmml.api.enums.OUTLIER_TREATMENT_METHOD;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.ExpressionsUtils;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;

public class KiePMMLNormContinuous
extends AbstractKiePMMLComponent
implements KiePMMLExpression {
    private static final long serialVersionUID = -7935602676734880795L;
    protected final List<KiePMMLLinearNorm> linearNorms;
    private final KiePMMLLinearNorm firstLinearNorm;
    private final KiePMMLLinearNorm lastLinearNorm;
    private final OUTLIER_TREATMENT_METHOD outlierTreatmentMethod;
    private final Number mapMissingTo;

    public KiePMMLNormContinuous(String name, List<KiePMMLExtension> extensions, List<KiePMMLLinearNorm> linearNorms, OUTLIER_TREATMENT_METHOD outlierTreatmentMethod, Number mapMissingTo) {
        super(name, extensions);
        KiePMMLNormContinuous.sortLinearNorms(linearNorms);
        this.linearNorms = linearNorms;
        this.firstLinearNorm = linearNorms.get(0);
        this.lastLinearNorm = linearNorms.get(linearNorms.size() - 1);
        this.outlierTreatmentMethod = outlierTreatmentMethod;
        this.mapMissingTo = mapMissingTo;
    }

    static void sortLinearNorms(List<KiePMMLLinearNorm> toSort) {
        toSort.sort((o1, o2) -> (int)(o1.getOrig() - o2.getOrig()));
    }

    @Override
    public Object evaluate(ProcessingDTO processingDTO) {
        Number input = (Number)ExpressionsUtils.getFromPossibleSources(this.name, processingDTO).orElse(this.mapMissingTo);
        if (input == null) {
            throw new KiePMMLException("Failed to retrieve input number for " + this.name);
        }
        return this.evaluate(input);
    }

    Number evaluate(Number input) {
        if (input.doubleValue() >= this.firstLinearNorm.getOrig() && input.doubleValue() <= this.lastLinearNorm.getOrig()) {
            return this.evaluateExpectedValue(input);
        }
        return this.evaluateOutlierValue(input);
    }

    Number evaluateExpectedValue(Number input) {
        KiePMMLLinearNorm[] limitLinearNorms = this.getLimitExpectedValue(input);
        return KiePMMLNormContinuous.evaluate(input, limitLinearNorms);
    }

    Number evaluateOutlierValue(Number input) {
        switch (this.outlierTreatmentMethod) {
            case AS_IS: {
                KiePMMLLinearNorm[] limitLinearNorms = input.doubleValue() < this.firstLinearNorm.getOrig() ? this.linearNorms.subList(0, 2).toArray(new KiePMMLLinearNorm[0]) : this.linearNorms.subList(this.linearNorms.size() - 2, this.linearNorms.size()).toArray(new KiePMMLLinearNorm[0]);
                return KiePMMLNormContinuous.evaluate(input, limitLinearNorms);
            }
            case AS_MISSING_VALUES: {
                return this.mapMissingTo;
            }
            case AS_EXTREME_VALUES: {
                return input.doubleValue() < this.firstLinearNorm.getOrig() ? this.firstLinearNorm.getNorm() : this.lastLinearNorm.getNorm();
            }
        }
        throw new KiePMMLException("Unknown outlierTreatmentMethod " + this.outlierTreatmentMethod);
    }

    KiePMMLLinearNorm[] getLimitExpectedValue(Number input) {
        int counter2 = 0;
        KiePMMLLinearNorm linearNorm = this.linearNorms.get(counter2);
        KiePMMLLinearNorm startLinearNorm = null;
        while (linearNorm.getOrig() <= input.doubleValue() && counter2 < this.linearNorms.size() - 1) {
            startLinearNorm = linearNorm;
            linearNorm = this.linearNorms.get(++counter2);
        }
        int startIndex = this.linearNorms.indexOf(startLinearNorm);
        counter2 = this.linearNorms.size() - 1;
        linearNorm = this.linearNorms.get(counter2);
        KiePMMLLinearNorm endLinearNorm = null;
        while (linearNorm.getOrig() >= input.doubleValue() && counter2 > startIndex) {
            endLinearNorm = linearNorm;
            linearNorm = this.linearNorms.get(--counter2);
        }
        return new KiePMMLLinearNorm[]{startLinearNorm, endLinearNorm};
    }

    static Number evaluate(Number input, KiePMMLLinearNorm[] limitLinearNorms) {
        KiePMMLLinearNorm startLinearNorm = limitLinearNorms[0];
        KiePMMLLinearNorm endLinearNorm = limitLinearNorms[1];
        return startLinearNorm.getNorm() + (input.doubleValue() - startLinearNorm.getOrig()) / (endLinearNorm.getOrig() - startLinearNorm.getOrig()) * (endLinearNorm.getNorm() - startLinearNorm.getNorm());
    }
}

