/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionBiPredicate;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionIntFunction;
import org.wildfly.common.function.ExceptionLongFunction;
import org.wildfly.common.function.ExceptionObjIntConsumer;
import org.wildfly.common.function.ExceptionPredicate;
import org.wildfly.common.function.ExceptionSupplier;

public interface Scoped {
    default public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Runnable::run, action);
    }

    default public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunctionEx(Callable::call, action);
    }

    default public <T, R> R runAsFunction(Function<T, R> action, T parameter) {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunction(Function::apply, action, parameter);
    }

    public <T, U, R> R runAsFunction(BiFunction<T, U, R> var1, T var2, U var3);

    default public <T> void runAsConsumer(Consumer<T> action, T parameter) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Consumer::accept, action, parameter);
    }

    public <T, U> void runAsConsumer(BiConsumer<T, U> var1, T var2, U var3);

    public <T> void runAsObjIntConsumer(ObjIntConsumer<T> var1, T var2, int var3);

    default public <T> T runAsSupplier(Supplier<T> action) {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunction(Supplier::get, action);
    }

    default public <T, R, E extends Exception> R runAsFunctionEx(ExceptionFunction<T, R, E> action, T parameter) throws E {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunctionEx(ExceptionFunction::apply, action, parameter);
    }

    public <T, U, R, E extends Exception> R runAsFunctionEx(ExceptionBiFunction<T, U, R, E> var1, T var2, U var3) throws E;

    default public <T, E extends Exception> void runAsConsumerEx(ExceptionConsumer<T, E> action, T parameter) throws E {
        if (action == null) {
            return;
        }
        this.runAsConsumerEx(ExceptionConsumer::accept, action, parameter);
    }

    public <T, U, E extends Exception> void runAsConsumerEx(ExceptionBiConsumer<T, U, E> var1, T var2, U var3) throws E;

    public <T, E extends Exception> void runAsObjIntConsumerEx(ExceptionObjIntConsumer<T, E> var1, T var2, int var3) throws E;

    default public <T, E extends Exception> T runAsSupplierEx(ExceptionSupplier<T, E> action) throws E {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunctionEx(ExceptionSupplier::get, action);
    }

    default public <R> R runAsAction(PrivilegedAction<R> action) {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunction(PrivilegedAction::run, action);
    }

    default public <R> R runAsExceptionAction(PrivilegedExceptionAction<R> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        try {
            return (R)this.runAsFunctionEx(PrivilegedExceptionAction::run, action);
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    default public <T, U> boolean runAsBiPredicate(BiPredicate<T, U> predicate, T param1, U param2) {
        throw new UnsupportedOperationException();
    }

    default public <T, U, E extends Exception> boolean runAsExBiPredicate(ExceptionBiPredicate<T, U, E> predicate, T param1, U param2) throws E {
        throw new UnsupportedOperationException();
    }

    default public <T> boolean runAsPredicate(Predicate<T> predicate, T param2) {
        if (predicate == null) {
            return false;
        }
        return this.runAsBiPredicate(Predicate::test, predicate, param2);
    }

    default public <T, E extends Exception> boolean runAsExPredicate(ExceptionPredicate<T, E> predicate, T param2) throws E {
        if (predicate == null) {
            return false;
        }
        return this.runAsExBiPredicate(ExceptionPredicate::test, predicate, param2);
    }

    default public <T> T runAsIntFunction(IntFunction<T> action, int value) {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunction(IntFunction::apply, action, value);
    }

    default public <T, E extends Exception> T runAsExIntFunction(ExceptionIntFunction<T, E> action, int value) throws E {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunctionEx(ExceptionIntFunction::apply, action, value);
    }

    default public <T> T runAsLongFunction(LongFunction<T> action, long value) {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunction(LongFunction::apply, action, value);
    }

    default public <T, E extends Exception> T runAsExLongFunction(ExceptionLongFunction<T, E> action, long value) throws E {
        if (action == null) {
            return null;
        }
        return (T)this.runAsFunctionEx(ExceptionLongFunction::apply, action, value);
    }
}

