/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl._private;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.sasl._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void unableToResolveMechanismConfiguration(Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.unableToResolveMechanismConfiguration$str(), new Object[0]);
    }

    protected String unableToResolveMechanismConfiguration$str() {
        return "ELY01157: Unable to resolve MechanismConfiguration for MechanismInformation";
    }

    protected String mechMessageAfterComplete$str() {
        return "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    }

    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageAfterComplete$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String mechAuthenticationNotComplete$str() {
        return "ELY05005: Authentication mechanism authentication is not yet complete";
    }

    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.mechAuthenticationNotComplete$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechSelectorUnexpectedChar$str() {
        return "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    }

    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(int codePoint, long offset, String string) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechSelectorTokenNotAllowed$str() {
        return "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    }

    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(String token, long offset, String string) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorTokenNotAllowed$str(), token, offset, string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechSelectorUnexpectedEnd$str() {
        return "ELY05020: Unexpected end of mechanism selection string \"%s\"";
    }

    @Override
    public final IllegalArgumentException mechSelectorUnexpectedEnd(String string) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorUnexpectedEnd$str(), string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthenticationFailed$str() {
        return "ELY05058: Authentication failed";
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationFailed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String wrappingNotConfigured$str() {
        return "ELY05090: Wrapping is not configured";
    }

    @Override
    public final IllegalStateException wrappingNotConfigured() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.wrappingNotConfigured$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNonAsciiSpace$str() {
        return "ELY05130: Invalid non-ASCII space \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidNonAsciiSpace(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNonAsciiSpace$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return "ELY05053: Callback handler failed for unknown reason";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerFailedForUnknownReason$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidAsciiControl$str() {
        return "ELY05131: Invalid ASCII control \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidAsciiControl(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidAsciiControl$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNonAsciiControl$str() {
        return "ELY05132: Invalid non-ASCII control \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidNonAsciiControl(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNonAsciiControl$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidPrivateUseCharacter$str() {
        return "ELY05133: Invalid private use character \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidPrivateUseCharacter(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPrivateUseCharacter$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNonCharacterCodePoint$str() {
        return "ELY05134: Invalid non-character code point \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidNonCharacterCodePoint(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNonCharacterCodePoint$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSurrogateCodePoint$str() {
        return "ELY05135: Invalid surrogate code point \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidSurrogateCodePoint(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSurrogateCodePoint$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidPlainTextCodePoint$str() {
        return "ELY05136: Invalid plain text code point \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidPlainTextCodePoint(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPlainTextCodePoint$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNonCanonicalCodePoint$str() {
        return "ELY05137: Invalid non-canonical code point \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidNonCanonicalCodePoint(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNonCanonicalCodePoint$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidControlCharacter$str() {
        return "ELY05138: Invalid control character \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidControlCharacter(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidControlCharacter$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidTaggingCharacter$str() {
        return "ELY05139: Invalid tagging character \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidTaggingCharacter(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTaggingCharacter$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unassignedCodePoint$str() {
        return "ELY05140: Unassigned code point \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException unassignedCodePoint(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unassignedCodePoint$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSurrogatePairHightAtEnd$str() {
        return "ELY05141: Invalid surrogate pair (high at end of string) \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidSurrogatePairHightAtEnd(char input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSurrogatePairHightAtEnd$str(), Character.valueOf(input)));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSurrogatePairSecondIsNotLow$str() {
        return "ELY05142: Invalid surrogate pair (second is not low) \"0x%X 0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidSurrogatePairSecondIsNotLow(char high, char low) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSurrogatePairSecondIsNotLow$str(), Character.valueOf(high), Character.valueOf(low)));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSurrogatePairLowWithoutHigh$str() {
        return "ELY05143: Invalid surrogate pair (low without high) \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidSurrogatePairLowWithoutHigh(char low) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSurrogatePairLowWithoutHigh$str(), Character.valueOf(low)));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidCodePoint$str() {
        return "ELY05144: Invalid code point \"0x%X\"";
    }

    @Override
    public final IllegalArgumentException invalidCodePoint(int input) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCodePoint$str(), input));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String disallowedRalDirectionalityInL$str() {
        return "ELY05145: Disallowed R/AL directionality character in L string";
    }

    @Override
    public final IllegalArgumentException disallowedRalDirectionalityInL() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.disallowedRalDirectionalityInL$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String disallowedLDirectionalityInRal$str() {
        return "ELY05146: Disallowed L directionality character in R/AL string";
    }

    @Override
    public final IllegalArgumentException disallowedLDirectionalityInRal() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.disallowedLDirectionalityInRal$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String missingTrailingRal$str() {
        return "ELY05147: Missing trailing R/AL directionality character";
    }

    @Override
    public final IllegalArgumentException missingTrailingRal() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingTrailingRal$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidEscapeSequence$str() {
        return "ELY05148: Invalid escape sequence";
    }

    @Override
    public final IllegalArgumentException invalidEscapeSequence() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidEscapeSequence$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechServerTimedOut$str() {
        return "ELY05163: Authentication mechanism server timed out";
    }

    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerTimedOut$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }
}

