/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.kafka.client.serialization.ObjectMapperProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class ObjectMapperSerializer<T>
implements Serializer<T> {
    public static final String NULL_AS_NULL_CONFIG = "json.serialize.null-as-null";
    private final ObjectMapper objectMapper;
    private boolean nullAsNull = false;

    public ObjectMapperSerializer() {
        this(ObjectMapperProducer.get());
    }

    public ObjectMapperSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (configs.containsKey(NULL_AS_NULL_CONFIG) && Boolean.parseBoolean((String)configs.get(NULL_AS_NULL_CONFIG))) {
            this.nullAsNull = true;
        }
    }

    @Override
    public byte[] serialize(String topic, T data) {
        byte[] byArray;
        if (this.nullAsNull && data == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.objectMapper.writeValue(output, data);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return byArray;
    }

    @Override
    public void close() {
    }
}

