/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.helpers;

import io.smallrye.reactive.messaging.helpers.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> raw;
    private final Type useOwner;
    private final List<Type> typeArguments;

    ParameterizedTypeImpl(Class<?> raw, Type useOwner, List<Type> typeArguments) {
        this.raw = raw;
        this.useOwner = useOwner;
        this.typeArguments = Collections.unmodifiableList(new ArrayList<Type>(typeArguments));
    }

    @Override
    public Type getRawType() {
        return this.raw;
    }

    @Override
    public Type getOwnerType() {
        return this.useOwner;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.typeArguments.toArray(new Type[0]);
    }

    public String toString() {
        return TypeUtils.toString(this);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ParameterizedType && TypeUtils.equals((Type)this, (Type)((ParameterizedType)obj));
    }

    public int hashCode() {
        int result2 = 1136;
        result2 |= this.raw.hashCode();
        result2 <<= 4;
        result2 |= Objects.hashCode(this.useOwner);
        result2 <<= 8;
        return result2 |= this.typeArguments.hashCode();
    }
}

