/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentialsConverter;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true, publicConverter=false)
public class TokenCredentials
implements Credentials {
    private String token;
    private List<String> scopes;

    protected TokenCredentials() {
    }

    public TokenCredentials(String token) {
        this.token = token;
    }

    public TokenCredentials(JsonObject jsonObject) {
        TokenCredentialsConverter.fromJson(jsonObject, this);
    }

    public String getToken() {
        return this.token;
    }

    public TokenCredentials setToken(String token) {
        this.token = token;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public TokenCredentials setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public TokenCredentials addScope(String scope) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scope);
        return this;
    }

    @Override
    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.token == null || this.token.length() == 0) {
            throw new CredentialValidationException("token cannot be null or empty");
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject result2 = new JsonObject();
        TokenCredentialsConverter.toJson(this, result2);
        return result2;
    }

    public String toString() {
        return this.toJson().encode();
    }

    @Override
    public TokenCredentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        int spc;
        if (challenge != null && !"Bearer".equalsIgnoreCase(challenge.substring(0, spc = challenge.indexOf(32)))) {
            throw new IllegalArgumentException("Only 'Bearer' auth-scheme is supported");
        }
        this.checkValid(null);
        return this;
    }

    @Override
    public String toHttpAuthorization() {
        return "Bearer " + this.token;
    }
}

