/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.impl.AuthorizationConverter;
import java.util.Objects;

public class AndAuthorizationConverter {
    private static final String FIELD_TYPE = "type";
    private static final String TYPE_AND_AUTHORIZATION = "and";
    private static final String FIELD_AUTHORIZATIONS = "authorizations";

    public static JsonObject encode(AndAuthorization value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        JsonObject result2 = new JsonObject();
        result2.put(FIELD_TYPE, TYPE_AND_AUTHORIZATION);
        JsonArray authorizations = new JsonArray();
        result2.put(FIELD_AUTHORIZATIONS, authorizations);
        for (Authorization authorization : value.getAuthorizations()) {
            authorizations.add(AuthorizationConverter.encode(authorization));
        }
        return result2;
    }

    public static AndAuthorization decode(JsonObject json) throws IllegalArgumentException {
        Objects.requireNonNull(json);
        if (TYPE_AND_AUTHORIZATION.equals(json.getString(FIELD_TYPE))) {
            AndAuthorization result2 = AndAuthorization.create();
            JsonArray authorizations = json.getJsonArray(FIELD_AUTHORIZATIONS);
            for (int i = 0; i < authorizations.size(); ++i) {
                JsonObject authorization = authorizations.getJsonObject(i);
                result2.addAuthorization(AuthorizationConverter.decode(authorization));
            }
            return result2;
        }
        return null;
    }
}

