/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.NotAuthorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.impl.AndAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.NotAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.OrAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.PermissionBasedAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.RoleBasedAuthorizationConverter;
import io.vertx.ext.auth.authorization.impl.WildcardPermissionBasedAuthorizationConverter;
import java.util.Objects;

public class AuthorizationConverter {
    public static Authorization decode(JsonObject json) throws IllegalArgumentException {
        Objects.requireNonNull(json);
        Authorization result2 = AndAuthorizationConverter.decode(json);
        if (result2 == null && (result2 = NotAuthorizationConverter.decode(json)) == null && (result2 = OrAuthorizationConverter.decode(json)) == null && (result2 = PermissionBasedAuthorizationConverter.decode(json)) == null && (result2 = RoleBasedAuthorizationConverter.decode(json)) == null) {
            result2 = WildcardPermissionBasedAuthorizationConverter.decode(json);
        }
        return result2;
    }

    public static JsonObject encode(Authorization value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        if (value instanceof AndAuthorization) {
            return AndAuthorizationConverter.encode((AndAuthorization)value);
        }
        if (value instanceof NotAuthorization) {
            return NotAuthorizationConverter.encode((NotAuthorization)value);
        }
        if (value instanceof OrAuthorization) {
            return OrAuthorizationConverter.encode((OrAuthorization)value);
        }
        if (value instanceof PermissionBasedAuthorization) {
            return PermissionBasedAuthorizationConverter.encode((PermissionBasedAuthorization)value);
        }
        if (value instanceof RoleBasedAuthorization) {
            return RoleBasedAuthorizationConverter.encode((RoleBasedAuthorization)value);
        }
        if (value instanceof WildcardPermissionBasedAuthorization) {
            return WildcardPermissionBasedAuthorizationConverter.encode((WildcardPermissionBasedAuthorization)value);
        }
        throw new IllegalArgumentException("Unsupported authorization " + value.getClass());
    }
}

