/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.Authorizations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AuthorizationsImpl
implements Authorizations {
    private Map<String, Set<Authorization>> authorizations = new HashMap<String, Set<Authorization>>();

    @Override
    public Authorizations add(String providerId, Authorization authorization) {
        Objects.requireNonNull(providerId);
        Objects.requireNonNull(authorization);
        this.getOrCreateAuthorizations(providerId).add(authorization);
        return this;
    }

    @Override
    public Authorizations add(String providerId, Set<Authorization> authorizations) {
        Objects.requireNonNull(providerId);
        Objects.requireNonNull(authorizations);
        this.getOrCreateAuthorizations(providerId).addAll(authorizations);
        return this;
    }

    @Override
    public Authorizations clear(String providerId) {
        Objects.requireNonNull(providerId);
        this.authorizations.remove(providerId);
        return this;
    }

    @Override
    public Authorizations clear() {
        this.authorizations.clear();
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthorizationsImpl)) {
            return false;
        }
        AuthorizationsImpl other = (AuthorizationsImpl)obj;
        return !(this.authorizations == null ? other.authorizations != null : !this.authorizations.equals(other.authorizations));
    }

    @Override
    public Set<Authorization> get(String providerId) {
        Objects.requireNonNull(providerId);
        return this.authorizations.get(providerId);
    }

    private Set<Authorization> getOrCreateAuthorizations(String providerId) {
        Set result2 = this.authorizations.computeIfAbsent(providerId, k -> new HashSet());
        return result2;
    }

    @Override
    public Set<String> getProviderIds() {
        return this.authorizations.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.authorizations == null ? 0 : this.authorizations.hashCode());
        return result2;
    }
}

