/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.predicate;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.ext.web.client.impl.ClientPhase;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import io.vertx.ext.web.client.impl.predicate.ResponsePredicateResultImpl;
import io.vertx.ext.web.client.predicate.ErrorConverter;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import java.util.ArrayList;
import java.util.List;

public class PredicateInterceptor
implements Handler<HttpContext<?>> {
    @Override
    public void handle(HttpContext<?> httpContext) {
        if (httpContext.phase() == ClientPhase.RECEIVE_RESPONSE) {
            HttpRequestImpl request = (HttpRequestImpl)httpContext.request();
            HttpClientResponse resp = httpContext.clientResponse();
            List<ResponsePredicate> expectations = request.expectations;
            if (expectations != null) {
                for (ResponsePredicate expectation : expectations) {
                    ResponsePredicateResultImpl predicateResult;
                    try {
                        predicateResult = (ResponsePredicateResultImpl)expectation.apply(this.responseCopy(resp, httpContext, null));
                    }
                    catch (Exception e) {
                        httpContext.fail(e);
                        return;
                    }
                    if (predicateResult.succeeded()) continue;
                    ErrorConverter errorConverter = expectation.errorConverter();
                    if (!errorConverter.requiresBody()) {
                        predicateResult.setHttpResponse(this.responseCopy(resp, httpContext, null));
                        this.failOnPredicate(httpContext, errorConverter, predicateResult);
                    } else {
                        resp.bodyHandler(buffer -> {
                            predicateResult.setHttpResponse(this.responseCopy(resp, httpContext, buffer));
                            this.failOnPredicate(httpContext, errorConverter, predicateResult);
                        });
                        resp.resume();
                    }
                    return;
                }
            }
        }
        httpContext.next();
    }

    private <B> HttpResponseImpl<B> responseCopy(HttpClientResponse resp, HttpContext<?> httpContext, B value) {
        return new HttpResponseImpl<B>(resp.version(), resp.statusCode(), resp.statusMessage(), MultiMap.caseInsensitiveMultiMap().addAll(resp.headers()), null, new ArrayList<String>(resp.cookies()), value, httpContext.getRedirectedLocations());
    }

    private void failOnPredicate(HttpContext<?> ctx, ErrorConverter converter, ResponsePredicateResultImpl predicateResult) {
        Throwable result2;
        try {
            result2 = converter.apply(predicateResult);
        }
        catch (Exception e) {
            result2 = e;
        }
        if (result2 != null) {
            ctx.fail(result2);
        } else {
            ctx.fail(new NoStackTraceThrowable("Invalid HTTP response"));
        }
    }
}

