/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.AbstractKeyPairResourceParser;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class BouncyCastleKeyPairResourceParser
extends AbstractKeyPairResourceParser {
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Arrays.asList("BEGIN RSA PRIVATE KEY", "BEGIN DSA PRIVATE KEY", "BEGIN EC PRIVATE KEY"));
    public static final List<String> ENDERS = Collections.unmodifiableList(Arrays.asList("END RSA PRIVATE KEY", "END DSA PRIVATE KEY", "END EC PRIVATE KEY"));
    public static final BouncyCastleKeyPairResourceParser INSTANCE = new BouncyCastleKeyPairResourceParser();

    public BouncyCastleKeyPairResourceParser() {
        super(BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines, Map<String, String> headers) throws IOException, GeneralSecurityException {
        StringBuilder writer = new StringBuilder(beginMarker.length() + endMarker.length() + lines.size() * 80);
        writer.append(beginMarker).append(IoUtils.EOL);
        lines.forEach(l -> writer.append((String)l).append(IoUtils.EOL));
        writer.append(endMarker).append(IoUtils.EOL);
        String data = writer.toString();
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(dataBytes);){
            Collection<KeyPair> collection = this.extractKeyPairs(session, resourceKey, beginMarker, endMarker, passwordProvider, bais, headers);
            return collection;
        }
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream, Map<String, String> headers) throws IOException, GeneralSecurityException {
        KeyPair kp = BouncyCastleKeyPairResourceParser.loadKeyPair(session, resourceKey, stream, passwordProvider);
        return kp == null ? Collections.emptyList() : Collections.singletonList(kp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyPair loadKeyPair(SessionContext session, NamedResource resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        JcaPEMKeyConverter pemConverter;
        Object o;
        Throwable throwable;
        PEMParser r;
        block35: {
            String password;
            int retryIndex;
            r = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            throwable = null;
            try {
                o = r.readObject();
                SecurityProviderRegistrar registrar = SecurityUtils.getRegisteredProvider("BC");
                if (registrar == null) {
                    throw new NoSuchProviderException("BC registrar not available");
                }
                pemConverter = new JcaPEMKeyConverter();
                if (registrar.isNamedProviderUsed()) {
                    pemConverter.setProvider(registrar.getName());
                } else {
                    pemConverter.setProvider(registrar.getSecurityProvider());
                }
                if (!(o instanceof PEMEncryptedKeyPair)) break block35;
                if (provider == null) {
                    throw new CredentialException("Missing password provider for encrypted resource=" + resourceKey);
                }
                retryIndex = 0;
                while (true) {
                    block36: {
                        PEMKeyPair decoded;
                        password = provider.getPassword(session, resourceKey, retryIndex);
                        try {
                            if (GenericUtils.isEmpty(password)) {
                                throw new FailedLoginException("No password data for encrypted resource=" + resourceKey);
                            }
                            JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                            PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(password.toCharArray());
                            decoded = ((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor);
                        }
                        catch (IOException | RuntimeException | GeneralSecurityException e) {
                            FilePasswordProvider.ResourceDecodeResult result2 = provider.handleDecodeAttemptResult(session, resourceKey, retryIndex, password, e);
                            if (result2 == null) {
                                result2 = FilePasswordProvider.ResourceDecodeResult.TERMINATE;
                            }
                            switch (result2) {
                                case TERMINATE: {
                                    throw e;
                                }
                                case RETRY: {
                                    break block36;
                                }
                                case IGNORE: {
                                    KeyPair keyPair = null;
                                    if (r == null) return keyPair;
                                    if (throwable == null) {
                                        r.close();
                                        return keyPair;
                                    }
                                    try {
                                        r.close();
                                        return keyPair;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                        return keyPair;
                                    }
                                }
                                default: {
                                    throw new ProtocolException("Unsupported decode attempt result (" + (Object)((Object)result2) + ") for " + resourceKey);
                                }
                            }
                        }
                        o = decoded;
                        break;
                    }
                    ++retryIndex;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            provider.handleDecodeAttemptResult(session, resourceKey, retryIndex, password, null);
        }
        if (o instanceof PEMKeyPair) {
            return pemConverter.getKeyPair((PEMKeyPair)o);
        }
        if (!(o instanceof KeyPair)) throw new IOException("Failed to read " + resourceKey + " - unknown result object: " + o);
        return (KeyPair)o;
        finally {
            if (r != null) {
                if (throwable != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    r.close();
                }
            }
        }
    }
}

