/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.home.HomeFinder;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.ResourceLimitEvent;
import org.graalvm.polyglot.ResourceLimits;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.management.ExecutionEvent;

public final class Engine
implements AutoCloseable {
    final AbstractPolyglotImpl.AbstractEngineDispatch dispatch;
    final Object receiver;
    final Engine currentAPI;
    private static final Engine EMPTY = new Engine(null, null);
    private static final boolean JDK8_OR_EARLIER = System.getProperty("java.specification.version").compareTo("1.9") < 0;

    <T> Engine(AbstractPolyglotImpl.AbstractEngineDispatch dispatch, T receiver) {
        this.dispatch = dispatch;
        this.receiver = receiver;
        this.currentAPI = new Engine(this);
        if (dispatch != null) {
            dispatch.setAPI(receiver, this);
        }
    }

    private <T> Engine(Engine engine) {
        this.dispatch = engine.dispatch;
        this.receiver = engine.receiver;
        this.currentAPI = null;
    }

    public Map<String, Language> getLanguages() {
        return this.dispatch.getLanguages(this.receiver);
    }

    public Map<String, Instrument> getInstruments() {
        return this.dispatch.getInstruments(this.receiver);
    }

    public OptionDescriptors getOptions() {
        return this.dispatch.getOptions(this.receiver);
    }

    public String getVersion() {
        return this.dispatch.getVersion(this.receiver);
    }

    public void close(boolean cancelIfExecuting) {
        if (this.currentAPI == null) {
            throw new IllegalStateException("Engine instances that were indirectly received using Context.getCurrent() cannot be closed.");
        }
        this.dispatch.close(this.receiver, this, cancelIfExecuting);
    }

    @Override
    public void close() {
        this.close(false);
    }

    public String getImplementationName() {
        return this.dispatch.getImplementationName(this.receiver);
    }

    public static Engine create() {
        return Engine.newBuilder().build();
    }

    public static Builder newBuilder() {
        return EMPTY.new Builder();
    }

    public static Path findHome() {
        return HomeFinder.getInstance().getHomeFolder();
    }

    public Set<Source> getCachedSources() {
        return this.dispatch.getCachedSources(this.receiver);
    }

    static AbstractPolyglotImpl getImpl() {
        return ImplHolder.IMPL;
    }

    static Class<?> loadLanguageClass(String className) {
        return Engine.getImpl().loadLanguageClass(className);
    }

    static Collection<Engine> findActiveEngines() {
        return Engine.getImpl().findActiveEngines();
    }

    private static AbstractPolyglotImpl initEngineImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<AbstractPolyglotImpl>(){

            @Override
            public AbstractPolyglotImpl run() {
                AbstractPolyglotImpl polyglot = null;
                Class<?> servicesClass = null;
                if (Boolean.getBoolean("graalvm.ForcePolyglotInvalid")) {
                    polyglot = this.loadAndValidateProviders(Engine.createInvalidPolyglotImpl());
                } else if (JDK8_OR_EARLIER) {
                    try {
                        servicesClass = Class.forName("jdk.vm.ci.services.Services");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (servicesClass != null) {
                        try {
                            Method m = servicesClass.getDeclaredMethod("load", Class.class);
                            polyglot = this.loadAndValidateProviders(((Iterable)m.invoke(null, AbstractPolyglotImpl.class)).iterator());
                        }
                        catch (Throwable e) {
                            throw new InternalError(e);
                        }
                    }
                }
                if (polyglot == null) {
                    polyglot = this.loadAndValidateProviders(this.searchServiceLoader());
                }
                if (polyglot == null) {
                    polyglot = this.loadAndValidateProviders(Engine.createInvalidPolyglotImpl());
                }
                return polyglot;
            }

            private Iterator<? extends AbstractPolyglotImpl> searchServiceLoader() throws InternalError {
                return ServiceLoader.load(AbstractPolyglotImpl.class).iterator();
            }

            private AbstractPolyglotImpl loadAndValidateProviders(Iterator<? extends AbstractPolyglotImpl> providers) throws AssertionError {
                ArrayList<AbstractPolyglotImpl> impls = new ArrayList<AbstractPolyglotImpl>();
                while (providers.hasNext()) {
                    AbstractPolyglotImpl found = providers.next();
                    for (AbstractPolyglotImpl impl : impls) {
                        if (impl.getClass().getName().equals(found.getClass().getName())) {
                            throw new AssertionError((Object)"Same polyglot impl found twice on the classpath.");
                        }
                    }
                    impls.add(found);
                }
                Collections.sort(impls, Comparator.comparing(AbstractPolyglotImpl::getPriority));
                AbstractPolyglotImpl prev = null;
                for (AbstractPolyglotImpl impl : impls) {
                    impl.setNext(prev);
                    impl.setConstructors(APIAccessImpl.INSTANCE);
                    prev = impl;
                }
                return prev;
            }
        });
    }

    static Iterator<? extends AbstractPolyglotImpl> createInvalidPolyglotImpl() {
        return Arrays.asList(new PolyglotInvalid()).iterator();
    }

    static /* synthetic */ AbstractPolyglotImpl access$000() {
        return Engine.initEngineImpl();
    }

    private static class PolyglotInvalid
    extends AbstractPolyglotImpl {
        private final EmptySource source = new EmptySource(this);
        static boolean AOT;

        private PolyglotInvalid() {
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Context getCurrentContext() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> arguments, boolean useSystemProperties, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandlerOrStream, Object hostLanguage, boolean hostLanguageOnly) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Object createHostLanguage(AbstractPolyglotImpl.AbstractHostAccess access) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public Object buildLimits(long statementLimit, Predicate<Source> statementLimitSourceFilter, Consumer<ResourceLimitEvent> onLimit) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public AbstractPolyglotImpl.AbstractHostAccess createHostAccess() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public AbstractPolyglotImpl.AbstractManagementDispatch getManagementDispatch() {
            return new AbstractPolyglotImpl.AbstractManagementDispatch(this){

                @Override
                public boolean isExecutionEventStatement(Object impl) {
                    return false;
                }

                @Override
                public boolean isExecutionEventRoot(Object impl) {
                    return false;
                }

                @Override
                public boolean isExecutionEventExpression(Object impl) {
                    return false;
                }

                @Override
                public String getExecutionEventRootName(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public PolyglotException getExecutionEventException(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public Value getExecutionEventReturnValue(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public SourceSection getExecutionEventLocation(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public List<Value> getExecutionEventInputValues(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public void closeExecutionListener(Object impl) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }

                @Override
                public Object attachExecutionListener(Object engine, Consumer<ExecutionEvent> onEnter, Consumer<ExecutionEvent> onReturn, boolean expressions, boolean statements, boolean roots, Predicate<Source> sourceFilter, Predicate<String> rootFilter, boolean collectInputValues, boolean collectReturnValues, boolean collectErrors) {
                    throw PolyglotInvalid.noPolyglotImplementationFound();
                }
            };
        }

        private static RuntimeException noPolyglotImplementationFound() {
            String suggestion = AOT ? "Make sure a language is added to the classpath (e.g., native-image --language:js)." : "Make sure the truffle-api.jar is on the classpath.";
            return new IllegalStateException("No language and polyglot implementation was found on the classpath. " + suggestion);
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceDispatch getSourceDispatch() {
            return this.source;
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceSectionDispatch getSourceSectionDispatch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> loadLanguageClass(String className) {
            return null;
        }

        public Collection<Engine> findActiveEngines() {
            return Collections.emptyList();
        }

        @Override
        public void preInitializeEngine() {
        }

        @Override
        public void resetPreInitializedEngine() {
        }

        @Override
        public Value asValue(Object o) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public FileSystem newDefaultFileSystem() {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        @Override
        public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
            return new Object();
        }

        static {
            Boolean aot = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("com.oracle.graalvm.isaot");
                }
            });
            AOT = aot;
        }

        static class EmptySource
        extends AbstractPolyglotImpl.AbstractSourceDispatch {
            protected EmptySource(AbstractPolyglotImpl engineImpl) {
                super(engineImpl);
            }

            @Override
            public Source build(String language2, Object origin, URI uri, String name, String mimeType, Object content, boolean interactive, boolean internal, boolean cached, Charset encoding) throws IOException {
                throw PolyglotInvalid.noPolyglotImplementationFound();
            }

            @Override
            public String getLanguage(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String findLanguage(File file) throws IOException {
                return null;
            }

            @Override
            public String findLanguage(URL url) throws IOException {
                return null;
            }

            @Override
            public String findMimeType(File file) throws IOException {
                return null;
            }

            @Override
            public String findMimeType(URL url) throws IOException {
                return null;
            }

            @Override
            public String getMimeType(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String findLanguage(String mimeType) {
                return null;
            }

            @Override
            public String getName(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPath(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInteractive(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public URL getURL(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public URI getURI(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Reader getReader(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getCharacters(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getCharacters(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineCount(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineNumber(Object impl, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getColumnNumber(Object impl, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineStartOffset(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineLength(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toString(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object impl, Object otherImpl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInternal(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteSequence getBytes(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasCharacters(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasBytes(Object impl) {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class APIAccessImpl
    extends AbstractPolyglotImpl.APIAccess {
        private static final APIAccessImpl INSTANCE = new APIAccessImpl();

        APIAccessImpl() {
        }

        @Override
        public Context newContext(AbstractPolyglotImpl.AbstractContextDispatch dispatch, Object receiver, Engine engine) {
            return new Context(dispatch, receiver, engine);
        }

        @Override
        public Engine newEngine(AbstractPolyglotImpl.AbstractEngineDispatch dispatch, Object receiver) {
            return new Engine(dispatch, receiver);
        }

        @Override
        public Language newLanguage(AbstractPolyglotImpl.AbstractLanguageDispatch dispatch, Object receiver) {
            return new Language(dispatch, receiver);
        }

        @Override
        public Instrument newInstrument(AbstractPolyglotImpl.AbstractInstrumentDispatch dispatch, Object receiver) {
            return new Instrument(dispatch, receiver);
        }

        @Override
        public Object getReceiver(Instrument instrument) {
            return instrument.receiver;
        }

        @Override
        public Object getContext(Value value) {
            return value.context;
        }

        @Override
        public Value newValue(AbstractPolyglotImpl.AbstractValueDispatch dispatch, Object context, Object receiver) {
            return new Value(dispatch, context, receiver);
        }

        @Override
        public Source newSource(Object receiver) {
            return new Source(receiver);
        }

        @Override
        public SourceSection newSourceSection(Source source, Object receiver) {
            return new SourceSection(source, receiver);
        }

        @Override
        public AbstractPolyglotImpl.AbstractValueDispatch getDispatch(Value value) {
            return value.dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractInstrumentDispatch getDispatch(Instrument value) {
            return value.dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractContextDispatch getDispatch(Context context) {
            return context.dispatch;
        }

        @Override
        public AbstractPolyglotImpl.AbstractEngineDispatch getDispatch(Engine engine) {
            return engine.dispatch;
        }

        @Override
        public ResourceLimitEvent newResourceLimitsEvent(Context context) {
            return new ResourceLimitEvent(context);
        }

        @Override
        public AbstractPolyglotImpl.AbstractLanguageDispatch getDispatch(Language value) {
            return value.dispatch;
        }

        @Override
        public Object getReceiver(ResourceLimits value) {
            return value.receiver;
        }

        @Override
        public PolyglotException newLanguageException(String message, AbstractPolyglotImpl.AbstractExceptionDispatch dispatch, Object receiver) {
            return new PolyglotException(message, dispatch, receiver);
        }

        @Override
        public AbstractPolyglotImpl.AbstractStackFrameImpl getDispatch(PolyglotException.StackFrame value) {
            return value.impl;
        }

        @Override
        public Object getReceiver(Value value) {
            return value.receiver;
        }

        @Override
        public Object getReceiver(Context context) {
            return context.receiver;
        }

        @Override
        public Object getReceiver(Engine engine) {
            return engine.receiver;
        }

        @Override
        public Object getReceiver(PolyglotException polyglot) {
            return polyglot.impl;
        }

        @Override
        public PolyglotException.StackFrame newPolyglotStackTraceElement(AbstractPolyglotImpl.AbstractStackFrameImpl dispatch, Object receiver) {
            PolyglotException polyglotException = (PolyglotException)receiver;
            polyglotException.getClass();
            return new PolyglotException.StackFrame(polyglotException, dispatch);
        }

        @Override
        public boolean allowsAccess(HostAccess access, AnnotatedElement element) {
            return access.allowsAccess(element);
        }

        @Override
        public boolean allowsImplementation(HostAccess access, Class<?> type) {
            return access.allowsImplementation(type);
        }

        @Override
        public List<Object> getTargetMappings(HostAccess access) {
            return access.getTargetMappings();
        }

        @Override
        public boolean isArrayAccessible(HostAccess access) {
            return access.allowArrayAccess;
        }

        @Override
        public boolean isListAccessible(HostAccess access) {
            return access.allowListAccess;
        }

        @Override
        public boolean isBufferAccessible(HostAccess access) {
            return access.allowBufferAccess;
        }

        @Override
        public boolean isIterableAccessible(HostAccess access) {
            return access.allowIterableAccess;
        }

        @Override
        public boolean isIteratorAccessible(HostAccess access) {
            return access.allowIteratorAccess;
        }

        @Override
        public boolean isMapAccessible(HostAccess access) {
            return access.allowMapAccess;
        }

        @Override
        public Object getHostAccessImpl(HostAccess conf) {
            return conf.impl;
        }

        @Override
        public void setHostAccessImpl(HostAccess conf, Object impl) {
            conf.impl = impl;
        }

        @Override
        public UnmodifiableEconomicSet<String> getEvalAccess(PolyglotAccess access, String language2) {
            return access.getEvalAccess(language2);
        }

        @Override
        public UnmodifiableEconomicSet<String> getBindingsAccess(PolyglotAccess access) {
            return access.getBindingsAccess();
        }

        @Override
        public String validatePolyglotAccess(PolyglotAccess access, UnmodifiableEconomicSet<String> languages) {
            return access.validate(languages);
        }
    }

    public final class Builder {
        private OutputStream out = System.out;
        private OutputStream err = System.err;
        private InputStream in = System.in;
        private Map<String, String> options = new HashMap<String, String>();
        private boolean allowExperimentalOptions = false;
        private boolean useSystemProperties = true;
        private boolean boundEngine;
        private MessageTransport messageTransport;
        private Object customLogHandler;

        Builder() {
        }

        Builder setBoundEngine(boolean boundEngine) {
            this.boundEngine = boundEngine;
            return this;
        }

        public Builder out(OutputStream out) {
            Objects.requireNonNull(out);
            this.out = out;
            return this;
        }

        public Builder err(OutputStream err) {
            Objects.requireNonNull(err);
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            Objects.requireNonNull(in);
            this.in = in;
            return this;
        }

        public Builder allowExperimentalOptions(boolean enabled) {
            this.allowExperimentalOptions = enabled;
            return this;
        }

        public Builder useSystemProperties(boolean enabled) {
            this.useSystemProperties = enabled;
            return this;
        }

        public Builder option(String key, String value) {
            Objects.requireNonNull(key, "Key must not be null.");
            Objects.requireNonNull(value, "Value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public Builder options(Map<String, String> options) {
            for (String key : options.keySet()) {
                Objects.requireNonNull(options.get(key), "All option values must be non-null.");
            }
            this.options.putAll(options);
            return this;
        }

        public Builder serverTransport(MessageTransport serverTransport) {
            Objects.requireNonNull(serverTransport, "MessageTransport must be non null.");
            this.messageTransport = serverTransport;
            return this;
        }

        public Builder logHandler(Handler logHandler) {
            Objects.requireNonNull(logHandler, "Handler must be non null.");
            this.customLogHandler = logHandler;
            return this;
        }

        public Builder logHandler(OutputStream logOut) {
            Objects.requireNonNull(logOut, "LogOut must be non null.");
            this.customLogHandler = logOut;
            return this;
        }

        public Engine build() {
            AbstractPolyglotImpl polyglot = Engine.getImpl();
            if (polyglot == null) {
                throw new IllegalStateException("The Polyglot API implementation failed to load.");
            }
            Engine engine = polyglot.buildEngine(this.out, this.err, this.in, this.options, this.useSystemProperties, this.allowExperimentalOptions, this.boundEngine, this.messageTransport, this.customLogHandler, polyglot.createHostLanguage(polyglot.createHostAccess()), false);
            return engine;
        }
    }

    private static final class ImplHolder {
        private static AbstractPolyglotImpl IMPL = Engine.access$000();

        private ImplHolder() {
        }

        private static void preInitializeEngine() {
            IMPL.preInitializeEngine();
        }

        private static void resetPreInitializedEngine() {
            IMPL.resetPreInitializedEngine();
        }

        private static void debugContextPreInitialization() {
            if (!ImageInfo.inImageCode() && System.getProperty("polyglot.image-build-time.PreinitializeContexts") != null) {
                IMPL.preInitializeEngine();
            }
        }

        static {
            ImplHolder.debugContextPreInitialization();
        }
    }
}

