/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.spi.URLStreamHandlerProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ClasspathURLStreamHandlerProvider
extends URLStreamHandlerProvider {
    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("classpath".equals(protocol)) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    URL resource;
                    String path = u.getPath();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    URL uRL = resource = classLoader == null ? null : classLoader.getResource(path);
                    if (resource == null) {
                        resource = ClassLoader.getSystemClassLoader().getResource(path);
                    }
                    if (resource != null) {
                        return resource.openConnection();
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

