/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.logging;

import java.io.IOException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final String LOG_ROOT = "org.infinispan.";
    public static final Log CONFIG = Logger.getMessageLogger(Log.class, "org.infinispan.CONFIG");
    public static final Log CONTAINER = Logger.getMessageLogger(Log.class, "org.infinispan.CONTAINER");
    public static final Log SECURITY = Logger.getMessageLogger(Log.class, "org.infinispan.SECURITY");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Property %s could not be replaced as intended!", id=901)
    public void propertyCouldNotBeReplaced(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invocation of %s threw an exception %s. Exception is ignored.", id=902)
    public void ignoringException(String var1, String var2, @Cause Throwable var3);

    @Message(value="Error while initializing SSL context", id=904)
    public CacheConfigurationException sslInitializationException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to load %s from any of the following classloaders: %s", id=905)
    public void unableToLoadClass(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to an int! Using default value of %d", id=906)
    public void unableToConvertStringPropertyToInt(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a long! Using default value of %d", id=907)
    public void unableToConvertStringPropertyToLong(String var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert string property [%s] to a boolean! Using default value of %b", id=908)
    public void unableToConvertStringPropertyToBoolean(String var1, boolean var2);

    @Message(value="Unwrapping %s to a type of %s is not a supported", id=909)
    public IllegalArgumentException unableToUnwrap(Object var1, Class<?> var2);

    @Message(value="Illegal value for thread pool parameter(s) %s, it should be: %s", id=910)
    public CacheConfigurationException illegalValueThreadPoolParameter(String var1, String var2);

    @Message(value="Unwrapping of any instances in %s to a type of %s is not a supported", id=911)
    public IllegalArgumentException unableToUnwrapAny(String var1, Class<?> var2);

    @Message(value="Expecting a protected configuration for %s", id=912)
    public IllegalStateException unprotectedAttributeSet(String var1);

    @Message(value="Expecting a unprotected configuration for %s", id=913)
    public IllegalStateException protectedAttributeSet(String var1);

    @Message(value="Duplicate attribute '%s' in attribute set '%s'", id=914)
    public IllegalArgumentException attributeSetDuplicateAttribute(String var1, String var2);

    @Message(value="No such attribute '%s' in attribute set '%s'", id=915)
    public IllegalArgumentException noSuchAttribute(String var1, String var2);

    @Message(value="No attribute copier for type '%s'", id=916)
    public IllegalArgumentException noAttributeCopierForType(Class<?> var1);

    @Message(value="Cannot find resource '%s'", id=918)
    public IOException cannotFindResource(String var1);

    @Message(value="Multiple errors encountered while validating configuration", id=919)
    public CacheConfigurationException multipleConfigurationValidationErrors();

    @Message(value="Unable to load file using scheme %s", id=920)
    public UnsupportedOperationException unableToLoadFileUsingScheme(String var1);

    @Message(value="The alias '%s' does not exist in the key store '%s'", id=921)
    public SecurityException noSuchAliasInKeyStore(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception during rollback", id=922)
    public void errorRollingBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error enlisting resource", id=923)
    public void errorEnlistingResource(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="beforeCompletion() failed for %s", id=924)
    public void beforeCompletionFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error from resource manager!", id=925)
    public void unexpectedErrorFromResourceManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="afterCompletion() failed for %s", id=926)
    public void afterCompletionFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="exception while committing", id=927)
    public void errorCommittingTx(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="end() failed for %s", id=928)
    public void xaResourceEndFailed(String var1, @Cause Throwable var2);

    @Message(value="Media type cannot be empty or null!", id=929)
    public EncodingException missingMediaType();

    @Message(value="Invalid media type '%s': must contain a type and a subtype separated by '/'", id=930)
    public EncodingException invalidMediaTypeSubtype(String var1);

    @Message(value="Invalid media type '%s': invalid param '%s'", id=931)
    public EncodingException invalidMediaTypeParam(String var1, String var2);

    @Message(value="Invalid media type list '%s': comma expected", id=932)
    public EncodingException invalidMediaTypeListCommaMissing(String var1);

    @Message(value="Invalid media type list '%s': type expected after comma", id=933)
    public EncodingException invalidMediaTypeListCommaAtEnd(String var1);

    @Message(value="Errors converting '%s' from '%s' to '%s'", id=934)
    public EncodingException errorTranscoding(String var1, MediaType var2, MediaType var3, @Cause Throwable var4);

    @Message(value="Invalid Weight '%s'. Supported values are between 0 and 1.0", id=935)
    public EncodingException invalidWeight(Object var1);

    @Message(value="Class '%s' blocked by deserialization allow list. Adjust the configuration serialization allow list regular expression to include this class.", id=936)
    public CacheException classNotInAllowList(String var1);

    @Message(value="Invalid media type. Expected '%s' but got '%s'", id=937)
    public EncodingException invalidMediaType(String var1, String var2);

    @Message(value="Invalid text content '%s'", id=938)
    public EncodingException invalidTextContent(Object var1);

    @Message(value="Conversion of content '%s' from '%s' to '%s' not supported", id=939)
    public EncodingException conversionNotSupported(Object var1, String var2, String var3);

    @Message(value="Invalid application/x-www-form-urlencoded content: '%s'", id=940)
    public EncodingException cannotDecodeFormURLContent(Object var1);

    @Message(value="Error encoding content '%s' to '%s'", id=941)
    public EncodingException errorEncoding(Object var1, MediaType var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to convert property [%s] to an enum! Using default value of %d", id=942)
    public void unableToConvertStringPropertyToEnum(String var1, String var2);

    @Message(value="Feature %s is disabled!", id=944)
    public CacheConfigurationException featureDisabled(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using OpenSSL Provider", id=946)
    public void openSSLAvailable();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using Java SSL Provider", id=947)
    public void openSSLNotAvailable();

    @Message(value="Unsupported conversion of '%s' from '%s' to '%s'", id=948)
    public EncodingException unsupportedConversion(String var1, MediaType var2, MediaType var3);

    @Message(value="Unsupported conversion of '%s' to '%s'", id=949)
    public EncodingException unsupportedConversion(String var1, MediaType var2);

    @Message(value="%s reached.", id=29501)
    public CounterOutOfBoundsException counterOurOfBounds(String var1);

    @Message(value="Invalid counter type. Expected=%s but got %s", id=29514)
    public CounterException invalidCounterType(String var1, String var2);

    @Message(value="Counter '%s' is not defined.", id=29516)
    public CounterException undefinedCounter(String var1);

    @Message(value="WEAK and BOUNDED encoded flag isn't supported!", id=29522)
    public CounterException invalidCounterTypeEncoded();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot load %s", id=29523)
    public void cannotLoadMimeTypes(String var1);

    @Message(value="Cannot parse bytes quantity %s", id=29524)
    public IllegalArgumentException cannotParseQuantity(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Property '%s' has been deprecated. Please use '%s' instead.", id=29525)
    public void deprecatedProperty(String var1, String var2);
}

