/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.naming.Context;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.SecurityActions;

public final class Util {
    private static final boolean IS_ARRAYS_DEBUG = Boolean.getBoolean("infinispan.arrays.debug");
    private static final int COLLECTIONS_LIMIT = Integer.getInteger("infinispan.collections.limit", 8);
    public static final int HEX_DUMP_LIMIT = Integer.getInteger("infinispan.hexdump.limit", 64);
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final byte[][] EMPTY_BYTE_ARRAY_ARRAY = new byte[0][];
    public static final String GENERIC_JBOSS_MARSHALLING_CLASS = "org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller";
    public static final String JBOSS_USER_MARSHALLER_CLASS = "org.infinispan.jboss.marshalling.core.JBossUserMarshaller";
    private static final Log log = LogFactory.getLog(Util.class);
    private static final Set<Class<?>> BASIC_TYPES;
    private static final String HEX_VALUES = "0123456789ABCDEF";
    private static final char[] HEX_DUMP_CHARS;
    private static final String javaVendor;
    private static final String INDENT = "    ";

    public static <T> Class<T> loadClass(String classname, ClassLoader cl) {
        try {
            return Util.loadClassStrict(classname, cl);
        }
        catch (ClassNotFoundException e) {
            throw new CacheConfigurationException("Unable to instantiate class " + classname, e);
        }
    }

    public static ClassLoader[] getClassLoaders(ClassLoader appClassLoader) {
        return SecurityActions.getClassLoaders(appClassLoader);
    }

    public static <T> Class<T> loadClassStrict(String classname, ClassLoader userClassLoader) throws ClassNotFoundException {
        Object[] cls = Util.getClassLoaders(userClassLoader);
        ClassNotFoundException e = null;
        NoClassDefFoundError ne = null;
        for (ClassLoader classLoader : cls) {
            if (classLoader == null) continue;
            try {
                return Class.forName(classname, true, classLoader);
            }
            catch (ClassNotFoundException ce) {
                e = ce;
            }
            catch (NoClassDefFoundError ce) {
                ne = ce;
            }
        }
        if (ne != null) {
            log.unableToLoadClass(classname, Arrays.toString(cls), ne);
        }
        if (e != null) {
            throw e;
        }
        if (ne != null) {
            throw new ClassNotFoundException(classname, ne);
        }
        throw new IllegalStateException();
    }

    public static InputStream getResourceAsStream(String resourcePath, ClassLoader userClassLoader) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        InputStream is = null;
        for (ClassLoader cl : Util.getClassLoaders(userClassLoader)) {
            if (cl != null && (is = cl.getResourceAsStream(resourcePath)) != null) break;
        }
        return is;
    }

    public static String getResourceAsString(String resourcePath, ClassLoader userClassLoader) throws IOException {
        return Util.read(Util.getResourceAsStream(resourcePath, userClassLoader));
    }

    private static Method getFactoryMethod(Class<?> c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals("getInstance") || m.getParameterTypes().length != 0 || !Modifier.isStatic(m.getModifiers())) continue;
            return m;
        }
        return null;
    }

    public static <T> T newInstanceOrNull(Class<T> clazz, Class[] parameterTypes, Object ... arguments) {
        if (parameterTypes.length != arguments.length) {
            throw new IllegalArgumentException("Parameter type count: " + parameterTypes.length + " does not match parameter arguments count: " + arguments.length);
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            if (constructor != null) {
                return constructor.newInstance(arguments);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CacheConfigurationException("Unable to instantiate class " + clazz.getName() + " with constructor taking parameters " + Arrays.toString(arguments), e);
        }
        return null;
    }

    public static <T> T getInstance(Class<T> clazz) {
        try {
            return Util.getInstanceStrict(clazz);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException iae) {
            throw new CacheConfigurationException("Unable to instantiate class " + clazz.getName(), iae);
        }
    }

    public static <T> T getInstanceStrict(Class<T> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object instance = null;
        try {
            Method factoryMethod = Util.getFactoryMethod(clazz);
            if (factoryMethod != null) {
                instance = factoryMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            instance = null;
        }
        if (instance == null) {
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (T)instance;
    }

    public static <T> T getInstance(String classname, ClassLoader cl) {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class<T> clazz = Util.loadClass(classname, cl);
        return Util.getInstance(clazz);
    }

    public static <T> T getInstanceStrict(String classname, ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (classname == null) {
            throw new IllegalArgumentException("Cannot load null class!");
        }
        Class<T> clazz = Util.loadClassStrict(classname, cl);
        return Util.getInstanceStrict(clazz);
    }

    public static <T> T cloneWithMarshaller(Marshaller marshaller, T x) {
        if (marshaller == null) {
            throw new IllegalArgumentException("Cannot use null Marshaller for clone");
        }
        try {
            byte[] byteBuffer = marshaller.objectToByteBuffer(x);
            return (T)marshaller.objectFromByteBuffer(byteBuffer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException(e);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public static Runnable composeWithExceptions(Runnable a, Runnable b) {
        return () -> {
            try {
                a.run();
            }
            catch (Throwable e1) {
                try {
                    b.run();
                }
                catch (Throwable e2) {
                    try {
                        e1.addSuppressed(e2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e1;
            }
            b.run();
        };
    }

    private Util() {
    }

    public static boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static String prettyPrintTime(long time, TimeUnit unit) {
        return Util.prettyPrintTime(unit.toMillis(time));
    }

    public static long currentMillisFromNanotime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public static String prettyPrintTime(long millis) {
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        double toPrint = (double)millis / 1000.0;
        if (toPrint < 300.0) {
            return nf.format(toPrint) + " seconds";
        }
        if ((toPrint /= 60.0) < 120.0) {
            return nf.format(toPrint) + " minutes";
        }
        return nf.format(toPrint /= 60.0) + " hours";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream is) throws IOException {
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream is) throws IOException {
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            is.close();
        }
    }

    public static void close(AutoCloseable cl) {
        if (cl == null) {
            return;
        }
        try {
            cl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Socket s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(AutoCloseable ... cls) {
        for (AutoCloseable cl : cls) {
            Util.close(cl);
        }
    }

    public static void close(Context ctx) {
        if (ctx == null) {
            return;
        }
        try {
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseStream(OutputStream o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndCloseOutput(ObjectOutput o) {
        if (o == null) {
            return;
        }
        try {
            o.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String formatString(Object message, Object ... params) {
        if (params.length == 0) {
            return message == null ? "null" : message.toString();
        }
        return String.format(message.toString(), params);
    }

    public static String toStr(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            if (o.getClass().getComponentType().isPrimitive()) {
                if (o instanceof byte[]) {
                    return Util.printArray((byte[])o, false);
                }
                if (o instanceof int[]) {
                    return Arrays.toString((int[])o);
                }
                if (o instanceof long[]) {
                    return Arrays.toString((long[])o);
                }
                if (o instanceof short[]) {
                    return Arrays.toString((short[])o);
                }
                if (o instanceof double[]) {
                    return Arrays.toString((double[])o);
                }
                if (o instanceof float[]) {
                    return Arrays.toString((float[])o);
                }
                if (o instanceof char[]) {
                    return Arrays.toString((char[])o);
                }
                if (o instanceof boolean[]) {
                    return Arrays.toString((boolean[])o);
                }
            }
            return Arrays.toString((Object[])o);
        }
        return o.toString();
    }

    public static <E> String toStr(Collection<E> collection) {
        if (collection == null) {
            return "[]";
        }
        Iterator<E> i = collection.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int counter2 = 0;
        while (true) {
            E e;
            sb.append((e = i.next()) == collection ? "(this Collection)" : Util.toStr(e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            if (++counter2 >= COLLECTIONS_LIMIT) {
                return sb.append("...<").append(collection.size() - COLLECTIONS_LIMIT).append(" other elements>]").toString();
            }
            sb.append(", ");
        }
    }

    public static String printArray(byte[] array) {
        return Util.printArray(array, false);
    }

    public static String printArray(byte[] array, boolean withHash) {
        if (array == null) {
            return "null";
        }
        int limit = 16;
        StringBuilder sb = new StringBuilder();
        sb.append("[B0x");
        if (array.length <= limit || IS_ARRAYS_DEBUG) {
            sb.append(Util.toHexString(array));
            if (withHash) {
                sb.append(",h=");
                sb.append(Integer.toHexString(Arrays.hashCode(array)));
                sb.append(']');
            }
        } else {
            sb.append(Util.toHexString(array, limit));
            sb.append("..[");
            sb.append(array.length);
            if (withHash) {
                sb.append("],h=");
                sb.append(Integer.toHexString(Arrays.hashCode(array)));
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public static String toHexString(byte[] input) {
        return Util.toHexString(input, input != null ? input.length : 0);
    }

    public static String toHexString(byte[] input, int limit) {
        return Util.toHexString(input, 0, limit);
    }

    public static String toHexString(byte[] input, int offset, int limit) {
        if (input == null) {
            return "null";
        }
        int length = Math.min(limit - offset, input.length - offset);
        char[] result2 = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            result2[2 * i] = HEX_VALUES.charAt(input[i + offset] >> 4 & 0xF);
            result2[2 * i + 1] = HEX_VALUES.charAt(input[i + offset] & 0xF);
        }
        return String.valueOf(result2);
    }

    public static String padString(String s, int minWidth) {
        if (s.length() < minWidth) {
            StringBuilder sb = new StringBuilder(s);
            while (sb.length() < minWidth) {
                sb.append(" ");
            }
            return sb.toString();
        }
        return s;
    }

    public static String threadDump() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        StringBuilder threadDump = new StringBuilder();
        threadDump.append(timestamp);
        threadDump.append("\nFull thread dump ");
        threadDump.append("\n");
        Thread.getAllStackTraces().forEach((thread, elements) -> {
            threadDump.append("\"").append(thread.getName()).append("\" nid=").append(thread.getId()).append(" state=").append((Object)thread.getState()).append("\n");
            for (StackTraceElement e : elements) {
                threadDump.append(INDENT).append("at ").append(e.toString()).append("\n");
            }
        });
        return threadDump.toString();
    }

    public static CacheException rewrapAsCacheException(Throwable t) {
        if (t instanceof CacheException) {
            return (CacheException)t;
        }
        return new CacheException(t);
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... a) {
        if (a.length > 1) {
            return new HashSet<T>(Arrays.asList(a));
        }
        return Collections.singleton(a[0]);
    }

    public static String hexIdHashCode(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static String hexDump(byte[] data) {
        return Util.hexDump(data, data.length);
    }

    public static String hexDump(ByteBuffer buffer) {
        int bufferLength = buffer.remaining();
        int dumpLength = Math.min(bufferLength, HEX_DUMP_LIMIT);
        byte[] data = new byte[dumpLength];
        int pos = buffer.position();
        buffer.get(data);
        buffer.position(pos);
        return Util.hexDump(data, bufferLength);
    }

    public static String hexDump(byte[] buffer, int actualLength) {
        StringBuilder sb = new StringBuilder(buffer.length * 2 + 30);
        for (byte b : buffer) {
            Util.addHexByte(sb, b);
        }
        if (buffer.length <= actualLength) {
            sb.append("...");
        }
        sb.append(" (").append(actualLength).append(" bytes)");
        return sb.toString();
    }

    public static void addHexByte(StringBuilder buf, byte b) {
        int offset = (b & 0xFF) * 2;
        buf.append(HEX_DUMP_CHARS, offset, 2);
    }

    private static void addSingleHexChar(StringBuilder buf, byte b) {
        buf.append(HEX_VALUES.charAt(b & 0xF));
    }

    public static Double constructDouble(Class<?> type, Object o) {
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (double)((Long)o);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (Double)o;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (double)((Integer)o);
        }
        if (type.equals(String.class)) {
            return Double.valueOf((String)o);
        }
        throw new IllegalStateException(String.format("Expected a value that can be converted into a double: type=%s, value=%s", type, o));
    }

    public static int getNormalizedHash(Object object, Hash hashFct) {
        return hashFct.hash(object) & Integer.MAX_VALUE;
    }

    public static int getSegmentSize(int numSegments) {
        return (int)Math.ceil(2.147483648E9 / (double)numSegments);
    }

    public static boolean isIBMJavaVendor() {
        return javaVendor.toLowerCase().contains("ibm");
    }

    public static String join(List<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String string : strings) {
            if (!first) {
                sb.append(separator);
            } else {
                first = false;
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static int findNextHighestPowerOfTwo(int num) {
        if (num <= 1) {
            return 1;
        }
        if (num >= 0x40000000) {
            return 0x40000000;
        }
        int highestBit = Integer.highestOneBit(num);
        return num <= highestBit ? highestBit : highestBit << 1;
    }

    public static int hashCode(byte[] bytes, int size) {
        int contentLimit = size;
        if (size > bytes.length) {
            contentLimit = bytes.length;
        }
        int hashCode = 1;
        for (int i = 0; i < contentLimit; ++i) {
            hashCode = 31 * hashCode + bytes[i];
        }
        return hashCode;
    }

    public static String prettyPrintSubject(Subject subject) {
        return subject == null ? "null" : "Subject with principal(s): " + Util.toStr(subject.getPrincipals());
    }

    @SafeVarargs
    public static <T> T[] arrayConcat(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result2 = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result2, offset, array.length);
            offset += array.length;
        }
        return result2;
    }

    public static UUID threadLocalRandomUUID() {
        int i;
        byte[] data = new byte[16];
        ThreadLocalRandom.current().nextBytes(data);
        data[6] = (byte)(data[6] & 0xF);
        data[6] = (byte)(data[6] | 0x40);
        data[8] = (byte)(data[8] & 0x3F);
        data[8] = (byte)(data[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static String unicodeEscapeString(String s) {
        int len = s.length();
        StringBuilder out = new StringBuilder(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = s.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    out.append('\\');
                    out.append('\\');
                    continue;
                }
                out.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0) {
                        out.append('\\');
                    }
                    out.append(' ');
                    continue block8;
                }
                case '\t': {
                    out.append('\\');
                    out.append('t');
                    continue block8;
                }
                case '\n': {
                    out.append('\\');
                    out.append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\');
                    out.append('r');
                    continue block8;
                }
                case '\f': {
                    out.append('\\');
                    out.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    out.append('\\');
                    out.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        out.append('\\');
                        out.append('u');
                        Util.addSingleHexChar(out, (byte)(aChar >> 12 & 0xF));
                        Util.addSingleHexChar(out, (byte)(aChar >> 8 & 0xF));
                        Util.addSingleHexChar(out, (byte)(aChar >> 4 & 0xF));
                        Util.addSingleHexChar(out, (byte)(aChar & 0xF));
                        continue block8;
                    }
                    out.append(aChar);
                }
            }
        }
        return out.toString();
    }

    public static String unicodeUnescapeString(String s) {
        int len = s.length();
        StringBuilder out = new StringBuilder(len);
        for (int x = 0; x < len; ++x) {
            int ch = s.charAt(x);
            if (ch == 92) {
                if ((ch = s.charAt(++x)) == 117) {
                    int value = 0;
                    for (int i = 0; i < 4; ++i) {
                        if ((ch = (int)s.charAt(++x)) >= 48 && ch <= 57) {
                            value = (value << 4) + ch - 48;
                            continue;
                        }
                        if (ch >= 97 && ch <= 102) {
                            value = (value << 4) + 10 + ch - 97;
                            continue;
                        }
                        if (ch >= 65 && ch <= 70) {
                            value = (value << 4) + 10 + ch - 65;
                            continue;
                        }
                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                    }
                    out.append((char)value);
                    continue;
                }
                if (ch == 116) {
                    ch = 9;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 102) {
                    ch = 12;
                }
                out.append((char)ch);
                continue;
            }
            out.append((char)ch);
        }
        return out.toString();
    }

    public static <T> Supplier<T> getInstanceSupplier(Class<T> klass) {
        return () -> Util.getInstance(klass);
    }

    public static <T> Supplier<T> getInstanceSupplier(String className, ClassLoader classLoader) {
        return () -> Util.getInstance(className, classLoader);
    }

    public static void recursiveFileRemove(String directoryName) {
        File file = new File(directoryName);
        Util.recursiveFileRemove(file);
    }

    public static void recursiveFileRemove(Path path) {
        Util.recursiveFileRemove(path.toFile());
    }

    public static void recursiveFileRemove(File directory) {
        if (directory.exists()) {
            log.tracef("Deleting file %s", (Object)directory);
            Util.recursiveDelete(directory);
        }
    }

    private static void recursiveDelete(File f) {
        try {
            Files.walk(f.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void recursiveDirectoryCopy(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                try {
                    if (!source.equals(dir)) {
                        String relativize = source.relativize(dir).toString();
                        Path resolve = target.resolve(relativize);
                        Files.copy(dir, resolve, new CopyOption[0]);
                    }
                }
                catch (FileAlreadyExistsException relativize) {
                }
                catch (IOException x) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file).toString()), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean isBasicType(Class<?> type) {
        return BASIC_TYPES.contains(type);
    }

    public static String xmlify(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isUpperCase(ch)) {
                sb.append('-');
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static char[] toCharArray(String s) {
        return s == null ? null : s.toCharArray();
    }

    public static Object[] objectArray(int length) {
        return length == 0 ? EMPTY_OBJECT_ARRAY : new Object[length];
    }

    public static String[] stringArray(int length) {
        return length == 0 ? EMPTY_STRING_ARRAY : new String[length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameTempFile(File tempFile, File lockFile, File dstFile) throws IOException {
        FileLock lock = null;
        try (FileOutputStream lockFileOS = new FileOutputStream(lockFile);){
            lock = lockFileOS.getChannel().lock();
            Files.move(tempFile.toPath(), dstFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (lock != null && lock.isValid()) {
                lock.release();
            }
            if (!lockFile.delete()) {
                log.debugf("Unable to delete lock file %s", (Object)lockFile);
            }
        }
    }

    public static Throwable getRootCause(Throwable re) {
        if (re == null) {
            return null;
        }
        Throwable cause = re.getCause();
        if (cause != null) {
            return Util.getRootCause(cause);
        }
        return re;
    }

    public static Marshaller getJBossMarshaller(ClassLoader classLoader, ClassAllowList classAllowList) {
        try {
            Class<?> marshallerClass = classLoader.loadClass(GENERIC_JBOSS_MARSHALLING_CLASS);
            return Util.newInstanceOrNull(marshallerClass.asSubclass(Marshaller.class), new Class[]{ClassLoader.class, ClassAllowList.class}, classLoader, classAllowList);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> T requireNonNullElse(T obj, T defaultObj) {
        return obj != null ? obj : Objects.requireNonNull(defaultObj, "defaultObj");
    }

    public static void longToBytes(long val, byte[] array, int offset) {
        for (int i = 7; i > 0; --i) {
            array[offset + i] = (byte)val;
            val >>>= 8;
        }
        array[offset] = (byte)val;
    }

    public static String unquote(String s) {
        if (s.charAt(0) == '\"' || s.charAt(0) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    static {
        HEX_DUMP_CHARS = new char[512];
        javaVendor = SecurityActions.getProperty("java.vendor", "");
        BASIC_TYPES = new HashSet();
        BASIC_TYPES.add(Boolean.class);
        BASIC_TYPES.add(Byte.class);
        BASIC_TYPES.add(Character.class);
        BASIC_TYPES.add(Double.class);
        BASIC_TYPES.add(Float.class);
        BASIC_TYPES.add(Integer.class);
        BASIC_TYPES.add(Long.class);
        BASIC_TYPES.add(Short.class);
        BASIC_TYPES.add(String.class);
        for (int b = 0; b < 256; b = (int)((char)(b + 1))) {
            if (32 <= b && b <= 126) {
                Util.HEX_DUMP_CHARS[b * 2] = 92;
                Util.HEX_DUMP_CHARS[b * 2 + 1] = b;
                continue;
            }
            Util.HEX_DUMP_CHARS[b * 2] = HEX_VALUES.charAt((b & 0xF0) >> 4);
            Util.HEX_DUMP_CHARS[b * 2 + 1] = HEX_VALUES.charAt(b & 0xF);
        }
    }
}

