/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import org.infinispan.protostream.impl.Log;

final class DangerousActions {
    private static final Log log = Log.LogFactory.getLog(DangerousActions.class);

    private DangerousActions() {
    }

    static <A extends Annotation, C> TypeMirror getTypeMirror(A annotation, Function<A, Class<? extends C>> pureDanger) {
        try {
            Class<? extends C> clazz = pureDanger.apply(annotation);
            log.errorf("The function unexpectedly returned: %s", (Object)clazz);
            throw new IllegalStateException("MirroredTypeException was expected but it wasn't thrown!");
        }
        catch (MirroredTypeException mte) {
            TypeMirror typeMirror = mte.getTypeMirror();
            return typeMirror;
        }
    }

    static <A extends Annotation, C> List<? extends TypeMirror> getTypeMirrors(A annotation, Function<A, Class<? extends C>[]> pureDanger) {
        try {
            Object[] classes = pureDanger.apply(annotation);
            log.errorf("The function unexpectedly returned: %s", (Object)Arrays.toString(classes));
            throw new IllegalStateException("MirroredTypesException was expected but it wasn't thrown!");
        }
        catch (MirroredTypesException mte) {
            List<? extends TypeMirror> typeMirrors = mte.getTypeMirrors();
            return typeMirrors != null ? typeMirrors : Collections.emptyList();
        }
    }
}

