/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

abstract class BooleanCondition
extends BaseCondition {
    private static final Log log = Logger.getMessageLogger(Log.class, BooleanCondition.class.getName());
    private BaseCondition leftCondition;
    private BaseCondition rightCondition;

    protected BooleanCondition(QueryFactory queryFactory, BaseCondition leftCondition, BaseCondition rightCondition) {
        super(queryFactory);
        if (leftCondition == rightCondition) {
            throw log.leftAndRightCannotBeTheSame();
        }
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
    }

    public BaseCondition getFirstCondition() {
        return this.leftCondition;
    }

    public BaseCondition getSecondCondition() {
        return this.rightCondition;
    }

    public void replaceChildCondition(BaseCondition oldChild, BaseCondition newChild) {
        if (this.leftCondition == oldChild) {
            this.leftCondition = newChild;
        } else if (this.rightCondition == oldChild) {
            this.rightCondition = newChild;
        } else {
            throw log.conditionNotFoundInParent();
        }
        newChild.setParent(this);
    }

    @Override
    void setQueryBuilder(QueryBuilder queryBuilder) {
        super.setQueryBuilder(queryBuilder);
        if (this.leftCondition != null) {
            this.leftCondition.setQueryBuilder(queryBuilder);
        }
        if (this.rightCondition != null) {
            this.rightCondition.setQueryBuilder(queryBuilder);
        }
    }
}

