/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.impl.AndCondition;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.BetweenOperator;
import org.infinispan.query.dsl.impl.BooleanCondition;
import org.infinispan.query.dsl.impl.ContainsAllOperator;
import org.infinispan.query.dsl.impl.ContainsAnyOperator;
import org.infinispan.query.dsl.impl.ContainsOperator;
import org.infinispan.query.dsl.impl.EqOperator;
import org.infinispan.query.dsl.impl.GtOperator;
import org.infinispan.query.dsl.impl.GteOperator;
import org.infinispan.query.dsl.impl.InOperator;
import org.infinispan.query.dsl.impl.IsNullOperator;
import org.infinispan.query.dsl.impl.LikeOperator;
import org.infinispan.query.dsl.impl.LtOperator;
import org.infinispan.query.dsl.impl.LteOperator;
import org.infinispan.query.dsl.impl.NotCondition;
import org.infinispan.query.dsl.impl.OperatorAndArgument;
import org.infinispan.query.dsl.impl.OrCondition;
import org.infinispan.query.dsl.impl.ParameterExpression;
import org.infinispan.query.dsl.impl.PathExpression;
import org.infinispan.query.dsl.impl.SortCriteria;
import org.infinispan.query.dsl.impl.ValueRange;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

public class QueryStringCreator
implements Visitor<String> {
    private static final Log log = Logger.getMessageLogger(Log.class, QueryStringCreator.class.getName());
    public static final String DEFAULT_ALIAS = "_gen0";
    private static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";
    private static final TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    protected Map<String, Object> namedParameters;
    private DateFormat dateFormat;

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    @Override
    public String visit(BaseQueryBuilder baseQueryBuilder) {
        String havingCondition;
        BaseCondition baseCondition;
        String[] whereCondition;
        boolean isFirst;
        StringBuilder sb = new StringBuilder();
        if (baseQueryBuilder.getProjection() != null && baseQueryBuilder.getProjection().length != 0) {
            sb.append("SELECT ");
            isFirst = true;
            for (Expression projection : baseQueryBuilder.getProjection()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                this.appendAttributePath(sb, projection);
            }
            sb.append(' ');
        }
        sb.append("FROM ").append(baseQueryBuilder.getRootTypeName()).append(' ').append(DEFAULT_ALIAS);
        if (baseQueryBuilder.getWhereFilterCondition() != null && !(whereCondition = (baseCondition = baseQueryBuilder.getWhereFilterCondition().getRoot()).accept(this)).isEmpty()) {
            sb.append(" WHERE ").append((String)whereCondition);
        }
        if (baseQueryBuilder.getGroupBy() != null && baseQueryBuilder.getGroupBy().length != 0) {
            sb.append(" GROUP BY ");
            isFirst = true;
            for (String groupBy : baseQueryBuilder.getGroupBy()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(DEFAULT_ALIAS).append('.').append(groupBy);
            }
            sb.append(' ');
        }
        if (baseQueryBuilder.getHavingFilterCondition() != null && !(havingCondition = (baseCondition = baseQueryBuilder.getHavingFilterCondition().getRoot()).accept(this)).isEmpty()) {
            sb.append(" HAVING ").append(havingCondition);
        }
        if (baseQueryBuilder.getSortCriteria() != null && !baseQueryBuilder.getSortCriteria().isEmpty()) {
            sb.append(" ORDER BY ");
            boolean isFirst2 = true;
            for (SortCriteria sortCriteria : baseQueryBuilder.getSortCriteria()) {
                if (isFirst2) {
                    isFirst2 = false;
                } else {
                    sb.append(", ");
                }
                this.appendAttributePath(sb, sortCriteria.getAttributePath());
                sb.append(' ').append(sortCriteria.getSortOrder().name());
            }
        }
        return sb.toString();
    }

    protected <E extends Enum<E>> String renderEnum(E argument) {
        return '\'' + argument.name() + '\'';
    }

    @Override
    public String visit(AndCondition booleanCondition) {
        return this.generateBooleanCondition(booleanCondition, "AND");
    }

    @Override
    public String visit(OrCondition booleanCondition) {
        return this.generateBooleanCondition(booleanCondition, "OR");
    }

    private String generateBooleanCondition(BooleanCondition booleanCondition, String booleanOperator) {
        StringBuilder sb = new StringBuilder();
        boolean wrap = this.parentIsNotOfClass(booleanCondition, booleanCondition.getClass());
        if (wrap) {
            sb.append('(');
        }
        sb.append(booleanCondition.getFirstCondition().accept(this));
        sb.append(' ').append(booleanOperator).append(' ');
        sb.append(booleanCondition.getSecondCondition().accept(this));
        if (wrap) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String visit(NotCondition notCondition) {
        return "NOT " + notCondition.getFirstCondition().accept(this);
    }

    @Override
    public String visit(EqOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "=", "!=").toString();
    }

    @Override
    public String visit(GtOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), ">", "<=").toString();
    }

    @Override
    public String visit(GteOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), ">=", "<").toString();
    }

    @Override
    public String visit(LtOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "<", ">=").toString();
    }

    @Override
    public String visit(LteOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "<=", ">").toString();
    }

    @Override
    public String visit(BetweenOperator operator) {
        StringBuilder sb = new StringBuilder();
        ValueRange range = (ValueRange)operator.getArgument();
        if (!range.isIncludeLower() || !range.isIncludeUpper()) {
            boolean wrap = this.parentIsNotOfClass(operator.getAttributeCondition(), operator.getAttributeCondition().isNegated() ? OrCondition.class : AndCondition.class);
            if (wrap) {
                sb.append('(');
            }
            this.appendAttributePath(sb, operator.getAttributeCondition());
            sb.append(operator.getAttributeCondition().isNegated() ? (range.isIncludeLower() ? " < " : " <= ") : (range.isIncludeLower() ? " >= " : " > "));
            this.appendArgument(sb, range.getFrom());
            sb.append(operator.getAttributeCondition().isNegated() ? " OR " : " AND ");
            this.appendAttributePath(sb, operator.getAttributeCondition());
            sb.append(operator.getAttributeCondition().isNegated() ? (range.isIncludeUpper() ? " > " : " >= ") : (range.isIncludeUpper() ? " <= " : " < "));
            this.appendArgument(sb, range.getTo());
            if (wrap) {
                sb.append(')');
            }
        } else {
            if (operator.getAttributeCondition().isNegated()) {
                sb.append("NOT ");
            }
            this.appendAttributePath(sb, operator.getAttributeCondition());
            sb.append(" BETWEEN ");
            this.appendArgument(sb, range.getFrom());
            sb.append(" AND ");
            this.appendArgument(sb, range.getTo());
        }
        return sb.toString();
    }

    @Override
    public String visit(LikeOperator operator) {
        StringBuilder sb = new StringBuilder();
        this.appendAttributePath(sb, operator.getAttributeCondition());
        sb.append(' ');
        if (operator.getAttributeCondition().isNegated()) {
            sb.append("NOT ");
        }
        sb.append("LIKE ");
        this.appendArgument(sb, operator.getArgument());
        return sb.toString();
    }

    @Override
    public String visit(IsNullOperator operator) {
        StringBuilder sb = new StringBuilder();
        this.appendAttributePath(sb, operator.getAttributeCondition());
        sb.append(" IS ");
        if (operator.getAttributeCondition().isNegated()) {
            sb.append("NOT ");
        }
        sb.append("NULL");
        return sb.toString();
    }

    @Override
    public String visit(InOperator operator) {
        StringBuilder sb = new StringBuilder();
        this.appendAttributePath(sb, operator.getAttributeCondition());
        if (operator.getAttributeCondition().isNegated()) {
            sb.append(" NOT");
        }
        sb.append(" IN ");
        this.appendArgument(sb, operator.getArgument());
        return sb.toString();
    }

    @Override
    public String visit(ContainsOperator operator) {
        return this.appendSingleCondition(new StringBuilder(), operator.getAttributeCondition(), operator.getArgument(), "=", "!=").toString();
    }

    private StringBuilder appendSingleCondition(StringBuilder sb, AttributeCondition attributeCondition, Object argument, String op, String negativeOp) {
        this.appendAttributePath(sb, attributeCondition);
        sb.append(' ');
        sb.append(attributeCondition.isNegated() ? negativeOp : op);
        sb.append(' ');
        this.appendArgument(sb, argument);
        return sb;
    }

    private boolean parentIsNotOfClass(BaseCondition condition, Class<? extends BooleanCondition> expectedParentClass) {
        BaseCondition parent = condition.getParent();
        return parent != null && parent.getClass() != expectedParentClass;
    }

    @Override
    public String visit(ContainsAllOperator operator) {
        return this.generateMultipleBooleanCondition(operator, "AND", AndCondition.class);
    }

    @Override
    public String visit(ContainsAnyOperator operator) {
        return this.generateMultipleBooleanCondition(operator, "OR", OrCondition.class);
    }

    private String generateMultipleBooleanCondition(OperatorAndArgument operator, String booleanOperator, Class<? extends BooleanCondition> expectedParentClass) {
        List<Object> values;
        Object argument = operator.getArgument();
        if (argument instanceof Collection) {
            values = (List<Object>)argument;
        } else if (argument instanceof Object[]) {
            values = Arrays.asList((Object[])argument);
        } else {
            throw log.expectingCollectionOrArray();
        }
        StringBuilder sb = new StringBuilder();
        boolean wrap = this.parentIsNotOfClass(operator.getAttributeCondition(), expectedParentClass);
        if (wrap) {
            sb.append('(');
        }
        boolean isFirst = true;
        for (Object e : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(' ').append(booleanOperator).append(' ');
            }
            this.appendSingleCondition(sb, operator.getAttributeCondition(), e, "=", "!=");
        }
        if (wrap) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public String visit(AttributeCondition attributeCondition) {
        if (attributeCondition.getExpression() == null || attributeCondition.getOperatorAndArgument() == null) {
            throw log.incompleteSentence();
        }
        return attributeCondition.getOperatorAndArgument().accept(this);
    }

    private void appendAttributePath(StringBuilder sb, AttributeCondition attributeCondition) {
        this.appendAttributePath(sb, attributeCondition.getExpression());
    }

    private void appendAttributePath(StringBuilder sb, Expression expression) {
        PathExpression pathExpression = (PathExpression)expression;
        if (pathExpression.getAggregationType() != null) {
            sb.append(pathExpression.getAggregationType().name()).append('(');
        }
        sb.append(DEFAULT_ALIAS).append('.').append(pathExpression.getPath());
        if (pathExpression.getAggregationType() != null) {
            sb.append(')');
        }
    }

    private void appendArgument(StringBuilder sb, Object argument) {
        if (argument instanceof String) {
            sb.append('\'');
            String stringLiteral = argument.toString();
            for (int i = 0; i < stringLiteral.length(); ++i) {
                char c = stringLiteral.charAt(i);
                if (c == '\'') {
                    sb.append('\'');
                }
                sb.append(c);
            }
            sb.append('\'');
            return;
        }
        if (argument instanceof ParameterExpression) {
            ParameterExpression param2 = (ParameterExpression)argument;
            sb.append(':').append(param2.getParamName());
            if (this.namedParameters == null) {
                this.namedParameters = new HashMap<String, Object>(5);
            }
            this.namedParameters.put(param2.getParamName(), null);
            return;
        }
        if (argument instanceof PathExpression) {
            this.appendAttributePath(sb, (PathExpression)argument);
            return;
        }
        if (argument instanceof Number) {
            sb.append(argument);
            return;
        }
        if (argument instanceof Enum) {
            sb.append(this.renderEnum((Enum)argument));
            return;
        }
        if (argument instanceof Collection) {
            sb.append('(');
            boolean isFirstElement = true;
            for (Object o : (Collection)argument) {
                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    sb.append(", ");
                }
                this.appendArgument(sb, o);
            }
            sb.append(')');
            return;
        }
        if (argument instanceof Object[]) {
            sb.append('(');
            boolean isFirstElement = true;
            for (Object o : (Object[])argument) {
                if (isFirstElement) {
                    isFirstElement = false;
                } else {
                    sb.append(", ");
                }
                this.appendArgument(sb, o);
            }
            sb.append(')');
            return;
        }
        if (argument instanceof Date) {
            sb.append('\'').append(this.renderDate((Date)argument)).append('\'');
            return;
        }
        if (argument instanceof Instant) {
            sb.append('\'').append(this.renderInstant((Instant)argument)).append('\'');
            return;
        }
        sb.append(argument);
    }

    protected String renderDate(Date argument) {
        return this.getDateFormatter().format(argument);
    }

    protected String renderInstant(Instant argument) {
        return argument.toString();
    }

    private DateFormat getDateFormatter() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(DATE_FORMAT);
            this.dateFormat.setTimeZone(GMT_TZ);
        }
        return this.dateFormat;
    }
}

