/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.core.ExtendedCacheControl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class CacheControlDelegate
implements RuntimeDelegate.HeaderDelegate<CacheControl> {
    public static final CacheControlDelegate INSTANCE = new CacheControlDelegate();

    @Override
    public CacheControl fromString(String value) throws IllegalArgumentException {
        String[] directives;
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.cacheControlValueNull());
        }
        ExtendedCacheControl result2 = new ExtendedCacheControl();
        result2.setNoTransform(false);
        for (String directive : directives = value.split(",")) {
            String lowercase;
            directive = directive.trim();
            String[] nv = directive.split("=");
            String name = nv[0].trim();
            String val = null;
            if (nv.length > 1) {
                val = nv[1].trim();
                if (val.startsWith("\"")) {
                    val = val.substring(1);
                }
                if (val.endsWith("\"")) {
                    val = val.substring(0, val.length() - 1);
                }
            }
            if ("no-cache".equals(lowercase = name.toLowerCase())) {
                result2.setNoCache(true);
                if (val == null || "".equals(val)) continue;
                result2.getNoCacheFields().add(val);
                continue;
            }
            if ("private".equals(lowercase)) {
                result2.setPrivate(true);
                if (val == null || "".equals(val)) continue;
                result2.getPrivateFields().add(val);
                continue;
            }
            if ("no-store".equals(lowercase)) {
                result2.setNoStore(true);
                continue;
            }
            if ("max-age".equals(lowercase)) {
                if (val == null) {
                    throw new IllegalArgumentException(Messages.MESSAGES.cacheControlMaxAgeHeader(value));
                }
                result2.setMaxAge(Integer.valueOf(val));
                continue;
            }
            if ("s-maxage".equals(lowercase)) {
                if (val == null) {
                    throw new IllegalArgumentException(Messages.MESSAGES.cacheControlSMaxAgeHeader(value));
                }
                result2.setSMaxAge(Integer.valueOf(val));
                continue;
            }
            if ("no-transform".equals(lowercase)) {
                result2.setNoTransform(true);
                continue;
            }
            if ("must-revalidate".equals(lowercase)) {
                result2.setMustRevalidate(true);
                continue;
            }
            if ("proxy-revalidate".equals(lowercase)) {
                result2.setProxyRevalidate(true);
                continue;
            }
            if ("public".equals(lowercase)) {
                result2.setPublic(true);
                continue;
            }
            if (val == null) {
                val = "";
            }
            result2.getCacheExtension().put(name, val);
        }
        return result2;
    }

    private static StringBuffer addDirective(String directive, StringBuffer buffer) {
        if (buffer.length() > 0) {
            buffer.append(", ");
        }
        buffer.append(directive);
        return buffer;
    }

    @Override
    public String toString(CacheControl value) {
        ExtendedCacheControl ecc;
        List<String> fields;
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.paramNull());
        }
        StringBuffer buffer = new StringBuffer();
        if (value.isNoCache()) {
            fields = value.getNoCacheFields();
            if (fields.size() < 1) {
                CacheControlDelegate.addDirective("no-cache", buffer);
            } else {
                for (String field2 : value.getNoCacheFields()) {
                    CacheControlDelegate.addDirective("no-cache", buffer).append("=\"").append(field2).append("\"");
                }
            }
        }
        if (value instanceof ExtendedCacheControl && (ecc = (ExtendedCacheControl)value).isPublic()) {
            CacheControlDelegate.addDirective("public", buffer);
        }
        if (value.isMustRevalidate()) {
            CacheControlDelegate.addDirective("must-revalidate", buffer);
        }
        if (value.isNoTransform()) {
            CacheControlDelegate.addDirective("no-transform", buffer);
        }
        if (value.isNoStore()) {
            CacheControlDelegate.addDirective("no-store", buffer);
        }
        if (value.isProxyRevalidate()) {
            CacheControlDelegate.addDirective("proxy-revalidate", buffer);
        }
        if (value.getSMaxAge() > -1) {
            CacheControlDelegate.addDirective("s-maxage", buffer).append("=").append(value.getSMaxAge());
        }
        if (value.getMaxAge() > -1) {
            CacheControlDelegate.addDirective("max-age", buffer).append("=").append(value.getMaxAge());
        }
        if (value.isPrivate()) {
            fields = value.getPrivateFields();
            if (fields.size() < 1) {
                CacheControlDelegate.addDirective("private", buffer);
            } else {
                for (String field2 : value.getPrivateFields()) {
                    CacheControlDelegate.addDirective("private", buffer).append("=\"").append(field2).append("\"");
                }
            }
        }
        for (String key : value.getCacheExtension().keySet()) {
            String val = value.getCacheExtension().get(key);
            CacheControlDelegate.addDirective(key, buffer);
            if (val == null || "".equals(val)) continue;
            buffer.append("=\"").append(val).append("\"");
        }
        return buffer.toString();
    }
}

