/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.pmml;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.kie.api.pmml.DoubleFieldOutput;
import org.kie.api.pmml.IntegerFieldOutput;
import org.kie.api.pmml.PMML4Output;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.StringFieldOutput;

public class OutputFieldFactory {
    public static List<PMML4Output<?>> createOutputsFromResults(PMML4Result result2) {
        ArrayList results = new ArrayList();
        Set<String> varNames = result2.getResultVariables().keySet();
        String correlationId = result2.getCorrelationId();
        String segmentationId = result2.getSegmentationId();
        String segmentId = result2.getSegmentId();
        varNames.forEach(vn -> {
            Object obj = result2.getResultValue((String)vn, "value", new Object[0]);
            if (obj != null) {
                Double weight = result2.getResultValue((String)vn, "weight", Double.class, new Object[0]).orElse(null);
                String displayValue = result2.getResultValue((String)vn, "displayValue", String.class, new Object[0]).orElse(null);
                if (obj instanceof Integer) {
                    Integer value = (Integer)obj;
                    IntegerFieldOutput ifo = new IntegerFieldOutput(correlationId, segmentationId, segmentId, (String)vn, displayValue, weight, value);
                    results.add(ifo);
                } else if (obj instanceof Double) {
                    Double value = (Double)obj;
                    DoubleFieldOutput dfo = new DoubleFieldOutput(correlationId, segmentationId, segmentId, (String)vn, displayValue, weight, value);
                    results.add(dfo);
                } else if (obj instanceof String) {
                    String value = (String)obj;
                    StringFieldOutput sfo = new StringFieldOutput(correlationId, segmentationId, segmentId, (String)vn, displayValue, weight, value);
                    results.add(sfo);
                } else {
                    obj = result2.getResultValue((String)vn, null, new Object[0]);
                    if (obj != null) {
                        String value = obj.toString();
                        StringFieldOutput sfo = new StringFieldOutput(correlationId, segmentationId, segmentId, (String)vn, displayValue, weight, value);
                        results.add(sfo);
                    }
                }
            }
        });
        return results;
    }
}

