/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.process.CorrelationProperty;

public class CorrelationKeyXmlAdapter
extends XmlAdapter<String, CorrelationKey> {
    @Override
    public CorrelationKey unmarshal(String key) throws Exception {
        return CorrelationKeyXmlAdapter.unmarshalCorrelationKey(key);
    }

    public static CorrelationKey unmarshalCorrelationKey(String key) {
        CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        if (key == null || key.isEmpty()) {
            return factory.newCorrelationKey(Collections.EMPTY_LIST);
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String k : key.split(":")) {
            keys.add(k);
        }
        return KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(keys);
    }

    @Override
    public String marshal(CorrelationKey key) throws Exception {
        return CorrelationKeyXmlAdapter.marshalCorrelationKey(key);
    }

    public static String marshalCorrelationKey(CorrelationKey key) {
        if (key == null) {
            return "";
        }
        StringBuffer result2 = new StringBuffer();
        if (!key.getProperties().isEmpty()) {
            Iterator<CorrelationProperty<?>> iter = key.getProperties().iterator();
            CorrelationProperty<?> prop = iter.next();
            if (prop != null) {
                result2.append(prop.getValue().toString());
            }
            while (iter.hasNext()) {
                prop = iter.next();
                if (prop == null) continue;
                result2.append(":").append(prop.getValue().toString());
            }
        }
        return result2.toString();
    }
}

