/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.api;

import java.time.ZonedDateTime;
import org.kie.kogito.jobs.api.Job;

public class JobBuilder {
    private String id;
    private ZonedDateTime expirationTime;
    private Integer priority;
    private String callbackEndpoint;
    private String processInstanceId;
    private String rootProcessInstanceId;
    private String processId;
    private String rootProcessId;
    private Long repeatInterval;
    private Integer repeatLimit;
    private String nodeInstanceId;

    public JobBuilder id(String id) {
        this.id = id;
        return this;
    }

    public JobBuilder expirationTime(ZonedDateTime expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public JobBuilder priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public JobBuilder callbackEndpoint(String callbackEndpoint) {
        this.callbackEndpoint = callbackEndpoint;
        return this;
    }

    public JobBuilder processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public JobBuilder rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    public JobBuilder processId(String processId) {
        this.processId = processId;
        return this;
    }

    public JobBuilder rootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
        return this;
    }

    public JobBuilder repeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
        return this;
    }

    public JobBuilder repeatLimit(Integer repeatLimit) {
        this.repeatLimit = repeatLimit;
        return this;
    }

    public JobBuilder nodeInstanceId(String nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
        return this;
    }

    public Job build() {
        return new Job(this.id, this.expirationTime, this.priority, this.callbackEndpoint, this.processInstanceId, this.rootProcessInstanceId, this.processId, this.rootProcessId, this.repeatInterval, this.repeatLimit, this.nodeInstanceId);
    }

    public static JobBuilder builder() {
        return new JobBuilder();
    }
}

