/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.math3.util.Precision;
import org.kie.pmml.api.exceptions.KieEnumException;

public enum CAST_INTEGER {
    ROUND("round", CAST_INTEGER::getRound),
    CEILING("ceiling", CAST_INTEGER::getCeiling),
    FLOOR("floor", CAST_INTEGER::getFloor);

    private String name;
    private Function<Double, Integer> castingFunction;

    private CAST_INTEGER(String name, Function<Double, Integer> castingFunction) {
        this.name = name;
        this.castingFunction = castingFunction;
    }

    public static CAST_INTEGER byName(String name) {
        return Arrays.stream(CAST_INTEGER.values()).filter(value -> Objects.equals(name, value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find CAST_INTEGER with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Integer getScaledValue(Double toScale) {
        return this.castingFunction.apply(toScale);
    }

    static Integer getRound(Double toScale) {
        return (int)Precision.round(toScale, 0, 4);
    }

    static Integer getCeiling(Double toScale) {
        return (int)Precision.round(toScale, 0, 2);
    }

    static Integer getFloor(Double toScale) {
        return (int)Precision.round(toScale, 0, 3);
    }
}

