/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential._private;

import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.credential._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return "ELY00002: Parameter %s is empty";
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unrecognizedAlgorithm$str() {
        return "ELY00004: Unrecognized algorithm \"%s\"";
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String certificateChainIsEmpty$str() {
        return "ELY01037: Certificate chain is empty";
    }

    @Override
    public final IllegalArgumentException certificateChainIsEmpty() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateChainIsEmpty$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String insufficientDataToFormDigestAndSalt$str() {
        return "ELY01053: Insufficient data to form a digest and a salt";
    }

    @Override
    public final InvalidKeySpecException insufficientDataToFormDigestAndSalt() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.insufficientDataToFormDigestAndSalt$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSalt2$str() {
        return "ELY01054: Invalid salt \"%s%s\"";
    }

    @Override
    public final IllegalArgumentException invalidSalt(char lo, char hi) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSalt2$str(), Character.valueOf(lo), Character.valueOf(hi)));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidRounds$str() {
        return "ELY01055: Invalid rounds \"%s%s%s%s\"";
    }

    @Override
    public final IllegalArgumentException invalidRounds(char b0, char b1, char b2, char b3) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidRounds$str(), Character.valueOf(b0), Character.valueOf(b1), Character.valueOf(b2), Character.valueOf(b3)));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSalt4$str() {
        return "ELY01056: Invalid salt \"%s%s%s%s\"";
    }

    @Override
    public final IllegalArgumentException invalidSalt(char b0, char b1, char b2, char b3) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSalt4$str(), Character.valueOf(b0), Character.valueOf(b1), Character.valueOf(b2), Character.valueOf(b3)));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mismatchedPublicPrivateKeyAlgorithms$str() {
        return "ELY01059: Public and private key algorithm names are mismatched";
    }

    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mismatchedPublicPrivateKeyAlgorithms$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String publicKeyIsNull$str() {
        return "ELY01061: Public key is null";
    }

    @Override
    public final IllegalArgumentException publicKeyIsNull() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyIsNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String privateKeyIsNull$str() {
        return "ELY01063: Private key is null";
    }

    @Override
    public final IllegalArgumentException privateKeyIsNull() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyIsNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keySpecMustBeSecretKeySpec$str() {
        return "ELY02032: keySpec must be SecretKeySpect, given: [%s]";
    }

    @Override
    public final InvalidKeySpecException keySpecMustBeSecretKeySpec(String type) {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.keySpecMustBeSecretKeySpec$str(), type));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str() {
        return "ELY02033: key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]";
    }

    @Override
    public final InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(String keyAndKeySpec) {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str(), keyAndKeySpec));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return "ELY05151: Invalid OTP algorithm \"%s\"";
    }

    @Override
    public final SaslException mechInvalidOTPAlgorithm(String algorithm) {
        SaslException result2 = new SaslException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecUnrecognizedKeySpecAlgorithm$str() {
        return "ELY08001: Unrecognized key spec algorithm";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnrecognizedKeySpecAlgorithm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecPasswordSpecCannotBeRenderedAsString$str() {
        return "ELY08002: Password spec cannot be rendered as a string";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecPasswordSpecCannotBeRenderedAsString$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecUnknownCryptStringAlgorithm$str() {
        return "ELY08003: Unknown crypt string algorithm";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownCryptStringAlgorithm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecInvalidCharacterEncountered$str() {
        return "ELY08004: Invalid character encountered";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecInvalidCharacterEncountered$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecNoIterationCountTerminatorGiven$str() {
        return "ELY08005: No iteration count terminator given";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoIterationCountTerminatorGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecUnexpectedEndOfInputString$str() {
        return "ELY08006: Unexpected end of input string";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfInputString$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecNoSaltTerminatorGiven$str() {
        return "ELY08007: No salt terminator given";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSaltTerminatorGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidHashLength$str() {
        return "ELY08008: Invalid hash length";
    }

    @Override
    public final IllegalArgumentException invalidHashLength() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidHashLength$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecUnexpectedEndOfPasswordString$str() {
        return "ELY08009: Unexpected end of password string";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfPasswordString$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str() {
        return "ELY08010: Unexpected end of password string";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(Throwable cause) {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecInvalidMinorVersion$str() {
        return "ELY08011: Invalid minor version";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidMinorVersion() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecInvalidMinorVersion$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecCostMustBeTwoDigitInteger$str() {
        return "ELY08012: Invalid cost: must be a two digit integer";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecCostMustBeTwoDigitInteger$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return "ELY08013: No such MessageDigest algorithm for \"%s\"";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return "ELY08014: No such MessageDigest algorithm for \"%s\"";
    }

    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeyException result2 = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeyCannotVerifyPassword$str() {
        return "ELY08015: Cannot verify password";
    }

    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(Throwable cause) {
        InvalidKeyException result2 = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyCannotVerifyPassword$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08017: DES crypt password hash must be %d bytes";
    }

    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result2 = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return "ELY08018: Salt must be %d bytes (%d bits)";
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int bytes, int bits) {
        InvalidParameterSpecException result2 = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    }

    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int min, int max) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidSaltMustBeBytesLong$str() {
        return "ELY08021: Invalid salt: must be %d bytes long";
    }

    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(int length) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSaltMustBeBytesLong$str(), length));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08022: BSD DES crypt password hash must be %d bytes";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return "ELY08023: Salt must be %d bytes";
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int bytes) {
        InvalidParameterSpecException result2 = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return "ELY08024: BSD DES crypt password hash must be %d bytes";
    }

    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result2 = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String expected, String got) {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        InvalidKeySpecException result2 = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return "ELY08027: Unknown password type or algorithm";
    }

    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        InvalidKeyException result2 = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return "ELY08028: Invalid algorithm \"%s\"";
    }

    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String algorithm) {
        NoSuchAlgorithmException result2 = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String couldNotObtainKeySpecEncodingIdentifier$str() {
        return "ELY08029: Could not obtain key spec encoding identifier.";
    }

    @Override
    public final IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotObtainKeySpecEncodingIdentifier$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mismatchedPublicPrivateKeyParameters$str() {
        return "ELY09000: Public and private key parameters are mismatched";
    }

    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyParameters() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mismatchedPublicPrivateKeyParameters$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }
}

